Contributing
============

First of all, **thank you** for your interest in `wsdl2phpgenerator`, **you are awesome**!


Issues
------

If you experience problems, have questions or want to propose changes please provide as much information as possible regarding your usage.

You MUST provide the version of `wsdl2phpgenerator` and PHP you use.

You MUST provide all configuration arguments passed to `wsdl2phpgenerator`.

You SHOULD provide as much of the WSDL as possible if if the WSDL is not publicly available.

Questions can also be posted on [our mailing list](https://groups.google.com/forum/#!forum/wsdl2phpgenerator).


Pull requests
-------------

We have few rules to follow in order to ease code reviews, and discussions before
maintainers accept and merge your work.

You MUST follow the [PSR-1](http://www.php-fig.org/psr/1/) and
[PSR-2](http://www.php-fig.org/psr/2/). If you don't know about any of them, you
should really read the recommendations. Can't wait? Use the [PHP-CS-Fixer
tool](http://cs.sensiolabs.org/).

You MUST run the test suite.

You SHOULD write (or update) unit tests.

You SHOULD fix any new issues as identified by [our static analysis
suite](https://scrutinizer-ci.com/g/wsdl2phpgenerator/wsdl2phpgenerator/).

You SHOULD write documentation.

Please, write [commit messages that make
sense](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html),
and [rebase your branch](http://git-scm.com/book/en/Git-Branching-Rebasing)
before submitting your Pull Request.

One may ask you to [squash your
commits](http://blog.steveklabnik.com/posts/2012-11-08-how-to-squash-commits-in-a-github-pull-request)
too. This is used to "clean" your Pull Request before merging it (we don't want
commits such as `fix tests`, `fix 2`, `fix 3`, etc.).

Also, while creating your Pull Request on GitHub, you MUST write a description
which gives the context and/or explains why you are creating it.

Thank you!
