<?php

class ValidateOrderResponse
{

    /**
     * @var string $IsError
     */
    protected $IsError = null;

    /**
     * @var int $ErrorCode
     */
    protected $ErrorCode = null;

    /**
     * @var string $ErrorMessage
     */
    protected $ErrorMessage = null;

    /**
     * @var string $WebOrderId
     */
    protected $WebOrderId = null;

    /**
     * @var string $OrderNumber
     */
    protected $OrderNumber = null;

    /**
     * @param string $IsError
     * @param int $ErrorCode
     * @param string $ErrorMessage
     * @param string $WebOrderId
     * @param string $OrderNumber
     */
    public function __construct($IsError, $ErrorCode, $ErrorMessage, $WebOrderId, $OrderNumber)
    {
      $this->IsError = $IsError;
      $this->ErrorCode = $ErrorCode;
      $this->ErrorMessage = $ErrorMessage;
      $this->WebOrderId = $WebOrderId;
      $this->OrderNumber = $OrderNumber;
    }

    /**
     * @return string
     */
    public function getIsError()
    {
      return $this->IsError;
    }

    /**
     * @param string $IsError
     * @return ValidateOrderResponse
     */
    public function setIsError($IsError)
    {
      $this->IsError = $IsError;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->ErrorCode;
    }

    /**
     * @param int $ErrorCode
     * @return ValidateOrderResponse
     */
    public function setErrorCode($ErrorCode)
    {
      $this->ErrorCode = $ErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
      return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return ValidateOrderResponse
     */
    public function setErrorMessage($ErrorMessage)
    {
      $this->ErrorMessage = $ErrorMessage;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebOrderId()
    {
      return $this->WebOrderId;
    }

    /**
     * @param string $WebOrderId
     * @return ValidateOrderResponse
     */
    public function setWebOrderId($WebOrderId)
    {
      $this->WebOrderId = $WebOrderId;
      return $this;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
      return $this->OrderNumber;
    }

    /**
     * @param string $OrderNumber
     * @return ValidateOrderResponse
     */
    public function setOrderNumber($OrderNumber)
    {
      $this->OrderNumber = $OrderNumber;
      return $this;
    }

}
