<?php

class ValidateOrder
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $WebOrderId
     */
    protected $WebOrderId = null;

    /**
     * @var float $AmountET
     */
    protected $AmountET = null;

    /**
     * @var float $AmountIT
     */
    protected $AmountIT = null;

    /**
     * @var string $PaymentMethod
     */
    protected $PaymentMethod = null;

    /**
     * @var string $PaymentId
     */
    protected $PaymentId = null;

    /**
     * @var string $Carrier
     */
    protected $Carrier = null;

    /**
     * @var float $DiscountAmount
     */
    protected $DiscountAmount = null;

    /**
     * @var float $DiscountPercent
     */
    protected $DiscountPercent = null;

    /**
     * @var string $WebAddressId
     */
    protected $WebAddressId = null;

    /**
     * @var int $ShippingMethod
     */
    protected $ShippingMethod = null;

    /**
     * @var int $ShippingCondition
     */
    protected $ShippingCondition = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $WebOrderId
     * @param float $AmountET
     * @param float $AmountIT
     * @param string $PaymentMethod
     * @param string $PaymentId
     * @param string $Carrier
     * @param float $DiscountAmount
     * @param float $DiscountPercent
     * @param string $WebAddressId
     * @param int $ShippingMethod
     * @param int $ShippingCondition
     * @param string $Reference
     */
    public function __construct($HashKey, $PublicKey, $WebOrderId, $AmountET, $AmountIT, $PaymentMethod, $PaymentId, $Carrier, $DiscountAmount, $DiscountPercent, $WebAddressId, $ShippingMethod, $ShippingCondition, $Reference)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->WebOrderId = $WebOrderId;
      $this->AmountET = $AmountET;
      $this->AmountIT = $AmountIT;
      $this->PaymentMethod = $PaymentMethod;
      $this->PaymentId = $PaymentId;
      $this->Carrier = $Carrier;
      $this->DiscountAmount = $DiscountAmount;
      $this->DiscountPercent = $DiscountPercent;
      $this->WebAddressId = $WebAddressId;
      $this->ShippingMethod = $ShippingMethod;
      $this->ShippingCondition = $ShippingCondition;
      $this->Reference = $Reference;
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return ValidateOrder
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return ValidateOrder
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebOrderId()
    {
      return $this->WebOrderId;
    }

    /**
     * @param string $WebOrderId
     * @return ValidateOrder
     */
    public function setWebOrderId($WebOrderId)
    {
      $this->WebOrderId = $WebOrderId;
      return $this;
    }

    /**
     * @return float
     */
    public function getAmountET()
    {
      return $this->AmountET;
    }

    /**
     * @param float $AmountET
     * @return ValidateOrder
     */
    public function setAmountET($AmountET)
    {
      $this->AmountET = $AmountET;
      return $this;
    }

    /**
     * @return float
     */
    public function getAmountIT()
    {
      return $this->AmountIT;
    }

    /**
     * @param float $AmountIT
     * @return ValidateOrder
     */
    public function setAmountIT($AmountIT)
    {
      $this->AmountIT = $AmountIT;
      return $this;
    }

    /**
     * @return string
     */
    public function getPaymentMethod()
    {
      return $this->PaymentMethod;
    }

    /**
     * @param string $PaymentMethod
     * @return ValidateOrder
     */
    public function setPaymentMethod($PaymentMethod)
    {
      $this->PaymentMethod = $PaymentMethod;
      return $this;
    }

    /**
     * @return string
     */
    public function getPaymentId()
    {
      return $this->PaymentId;
    }

    /**
     * @param string $PaymentId
     * @return ValidateOrder
     */
    public function setPaymentId($PaymentId)
    {
      $this->PaymentId = $PaymentId;
      return $this;
    }

    /**
     * @return string
     */
    public function getCarrier()
    {
      return $this->Carrier;
    }

    /**
     * @param string $Carrier
     * @return ValidateOrder
     */
    public function setCarrier($Carrier)
    {
      $this->Carrier = $Carrier;
      return $this;
    }

    /**
     * @return float
     */
    public function getDiscountAmount()
    {
      return $this->DiscountAmount;
    }

    /**
     * @param float $DiscountAmount
     * @return ValidateOrder
     */
    public function setDiscountAmount($DiscountAmount)
    {
      $this->DiscountAmount = $DiscountAmount;
      return $this;
    }

    /**
     * @return float
     */
    public function getDiscountPercent()
    {
      return $this->DiscountPercent;
    }

    /**
     * @param float $DiscountPercent
     * @return ValidateOrder
     */
    public function setDiscountPercent($DiscountPercent)
    {
      $this->DiscountPercent = $DiscountPercent;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebAddressId()
    {
      return $this->WebAddressId;
    }

    /**
     * @param string $WebAddressId
     * @return ValidateOrder
     */
    public function setWebAddressId($WebAddressId)
    {
      $this->WebAddressId = $WebAddressId;
      return $this;
    }

    /**
     * @return int
     */
    public function getShippingMethod()
    {
      return $this->ShippingMethod;
    }

    /**
     * @param int $ShippingMethod
     * @return ValidateOrder
     */
    public function setShippingMethod($ShippingMethod)
    {
      $this->ShippingMethod = $ShippingMethod;
      return $this;
    }

    /**
     * @return int
     */
    public function getShippingCondition()
    {
      return $this->ShippingCondition;
    }

    /**
     * @param int $ShippingCondition
     * @return ValidateOrder
     */
    public function setShippingCondition($ShippingCondition)
    {
      $this->ShippingCondition = $ShippingCondition;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return ValidateOrder
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

}
