<?php

class UpdateAddressResponse
{

    /**
     * @var string $IsError
     */
    protected $IsError = null;

    /**
     * @var int $ErrorCode
     */
    protected $ErrorCode = null;

    /**
     * @var string $ErrorMessage
     */
    protected $ErrorMessage = null;

    /**
     * @var string $ClientId
     */
    protected $ClientId = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @var string $WebAddressId
     */
    protected $WebAddressId = null;

    /**
     * @param string $IsError
     * @param int $ErrorCode
     * @param string $ErrorMessage
     * @param string $ClientId
     * @param string $WebClientId
     * @param string $WebAddressId
     */
    public function __construct($IsError, $ErrorCode, $ErrorMessage, $ClientId, $WebClientId, $WebAddressId)
    {
      $this->IsError = $IsError;
      $this->ErrorCode = $ErrorCode;
      $this->ErrorMessage = $ErrorMessage;
      $this->ClientId = $ClientId;
      $this->WebClientId = $WebClientId;
      $this->WebAddressId = $WebAddressId;
    }

    /**
     * @return string
     */
    public function getIsError()
    {
      return $this->IsError;
    }

    /**
     * @param string $IsError
     * @return UpdateAddressResponse
     */
    public function setIsError($IsError)
    {
      $this->IsError = $IsError;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->ErrorCode;
    }

    /**
     * @param int $ErrorCode
     * @return UpdateAddressResponse
     */
    public function setErrorCode($ErrorCode)
    {
      $this->ErrorCode = $ErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
      return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return UpdateAddressResponse
     */
    public function setErrorMessage($ErrorMessage)
    {
      $this->ErrorMessage = $ErrorMessage;
      return $this;
    }

    /**
     * @return string
     */
    public function getClientId()
    {
      return $this->ClientId;
    }

    /**
     * @param string $ClientId
     * @return UpdateAddressResponse
     */
    public function setClientId($ClientId)
    {
      $this->ClientId = $ClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return UpdateAddressResponse
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebAddressId()
    {
      return $this->WebAddressId;
    }

    /**
     * @param string $WebAddressId
     * @return UpdateAddressResponse
     */
    public function setWebAddressId($WebAddressId)
    {
      $this->WebAddressId = $WebAddressId;
      return $this;
    }

}
