<?php

class Tarifs
{

    /**
     * @var string $Code
     */
    protected $Code = null;

    /**
     * @var string $WebCode
     */
    protected $WebCode = null;

    /**
     * @var float $Price
     */
    protected $Price = null;

    /**
     * @var float $LowerLimit
     */
    protected $LowerLimit = null;

    /**
     * @var boolean $IsTtc
     */
    protected $IsTtc = null;

    /**
     * @var string $AlternativeUnit
     */
    protected $AlternativeUnit = null;

    /**
     * @var string $AlternativeUnitFactor
     */
    protected $AlternativeUnitFactor = null;

    /**
     * @var int $BaremeCode
     */
    protected $BaremeCode = null;

    /**
     * @var int $TypeValeurCode
     */
    protected $TypeValeurCode = null;

    /**
     * @var string $TypeValeurLib
     */
    protected $TypeValeurLib = null;

    /**
     * @var int $TypeSeuilCode
     */
    protected $TypeSeuilCode = null;

    /**
     * @var string $TypeSeuilLib
     */
    protected $TypeSeuilLib = null;

    /**
     * @var int $BaseCalcCode
     */
    protected $BaseCalcCode = null;

    /**
     * @var string $BaseCalcLib
     */
    protected $BaseCalcLib = null;

    /**
     * @var string $Devise
     */
    protected $Devise = null;

    /**
     * @var string $IsError
     */
    protected $IsError = null;

    /**
     * @var int $ErrorCode
     */
    protected $ErrorCode = null;

    /**
     * @var string $ErrorMessage
     */
    protected $ErrorMessage = null;

    /**
     * @param string $Code
     * @param string $WebCode
     * @param float $Price
     * @param float $LowerLimit
     * @param boolean $IsTtc
     * @param string $AlternativeUnit
     * @param string $AlternativeUnitFactor
     * @param int $BaremeCode
     * @param int $TypeValeurCode
     * @param string $TypeValeurLib
     * @param int $TypeSeuilCode
     * @param string $TypeSeuilLib
     * @param int $BaseCalcCode
     * @param string $BaseCalcLib
     * @param string $Devise
     * @param string $IsError
     * @param int $ErrorCode
     * @param string $ErrorMessage
     */
    public function __construct($Code, $WebCode, $Price, $LowerLimit, $IsTtc, $AlternativeUnit, $AlternativeUnitFactor, $BaremeCode, $TypeValeurCode, $TypeValeurLib, $TypeSeuilCode, $TypeSeuilLib, $BaseCalcCode, $BaseCalcLib, $Devise, $IsError, $ErrorCode, $ErrorMessage)
    {
      $this->Code = $Code;
      $this->WebCode = $WebCode;
      $this->Price = $Price;
      $this->LowerLimit = $LowerLimit;
      $this->IsTtc = $IsTtc;
      $this->AlternativeUnit = $AlternativeUnit;
      $this->AlternativeUnitFactor = $AlternativeUnitFactor;
      $this->BaremeCode = $BaremeCode;
      $this->TypeValeurCode = $TypeValeurCode;
      $this->TypeValeurLib = $TypeValeurLib;
      $this->TypeSeuilCode = $TypeSeuilCode;
      $this->TypeSeuilLib = $TypeSeuilLib;
      $this->BaseCalcCode = $BaseCalcCode;
      $this->BaseCalcLib = $BaseCalcLib;
      $this->Devise = $Devise;
      $this->IsError = $IsError;
      $this->ErrorCode = $ErrorCode;
      $this->ErrorMessage = $ErrorMessage;
    }

    /**
     * @return string
     */
    public function getCode()
    {
      return $this->Code;
    }

    /**
     * @param string $Code
     * @return Tarifs
     */
    public function setCode($Code)
    {
      $this->Code = $Code;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebCode()
    {
      return $this->WebCode;
    }

    /**
     * @param string $WebCode
     * @return Tarifs
     */
    public function setWebCode($WebCode)
    {
      $this->WebCode = $WebCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getPrice()
    {
      return $this->Price;
    }

    /**
     * @param float $Price
     * @return Tarifs
     */
    public function setPrice($Price)
    {
      $this->Price = $Price;
      return $this;
    }

    /**
     * @return float
     */
    public function getLowerLimit()
    {
      return $this->LowerLimit;
    }

    /**
     * @param float $LowerLimit
     * @return Tarifs
     */
    public function setLowerLimit($LowerLimit)
    {
      $this->LowerLimit = $LowerLimit;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsTtc()
    {
      return $this->IsTtc;
    }

    /**
     * @param boolean $IsTtc
     * @return Tarifs
     */
    public function setIsTtc($IsTtc)
    {
      $this->IsTtc = $IsTtc;
      return $this;
    }

    /**
     * @return string
     */
    public function getAlternativeUnit()
    {
      return $this->AlternativeUnit;
    }

    /**
     * @param string $AlternativeUnit
     * @return Tarifs
     */
    public function setAlternativeUnit($AlternativeUnit)
    {
      $this->AlternativeUnit = $AlternativeUnit;
      return $this;
    }

    /**
     * @return string
     */
    public function getAlternativeUnitFactor()
    {
      return $this->AlternativeUnitFactor;
    }

    /**
     * @param string $AlternativeUnitFactor
     * @return Tarifs
     */
    public function setAlternativeUnitFactor($AlternativeUnitFactor)
    {
      $this->AlternativeUnitFactor = $AlternativeUnitFactor;
      return $this;
    }

    /**
     * @return int
     */
    public function getBaremeCode()
    {
      return $this->BaremeCode;
    }

    /**
     * @param int $BaremeCode
     * @return Tarifs
     */
    public function setBaremeCode($BaremeCode)
    {
      $this->BaremeCode = $BaremeCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getTypeValeurCode()
    {
      return $this->TypeValeurCode;
    }

    /**
     * @param int $TypeValeurCode
     * @return Tarifs
     */
    public function setTypeValeurCode($TypeValeurCode)
    {
      $this->TypeValeurCode = $TypeValeurCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeValeurLib()
    {
      return $this->TypeValeurLib;
    }

    /**
     * @param string $TypeValeurLib
     * @return Tarifs
     */
    public function setTypeValeurLib($TypeValeurLib)
    {
      $this->TypeValeurLib = $TypeValeurLib;
      return $this;
    }

    /**
     * @return int
     */
    public function getTypeSeuilCode()
    {
      return $this->TypeSeuilCode;
    }

    /**
     * @param int $TypeSeuilCode
     * @return Tarifs
     */
    public function setTypeSeuilCode($TypeSeuilCode)
    {
      $this->TypeSeuilCode = $TypeSeuilCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeSeuilLib()
    {
      return $this->TypeSeuilLib;
    }

    /**
     * @param string $TypeSeuilLib
     * @return Tarifs
     */
    public function setTypeSeuilLib($TypeSeuilLib)
    {
      $this->TypeSeuilLib = $TypeSeuilLib;
      return $this;
    }

    /**
     * @return int
     */
    public function getBaseCalcCode()
    {
      return $this->BaseCalcCode;
    }

    /**
     * @param int $BaseCalcCode
     * @return Tarifs
     */
    public function setBaseCalcCode($BaseCalcCode)
    {
      $this->BaseCalcCode = $BaseCalcCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getBaseCalcLib()
    {
      return $this->BaseCalcLib;
    }

    /**
     * @param string $BaseCalcLib
     * @return Tarifs
     */
    public function setBaseCalcLib($BaseCalcLib)
    {
      $this->BaseCalcLib = $BaseCalcLib;
      return $this;
    }

    /**
     * @return string
     */
    public function getDevise()
    {
      return $this->Devise;
    }

    /**
     * @param string $Devise
     * @return Tarifs
     */
    public function setDevise($Devise)
    {
      $this->Devise = $Devise;
      return $this;
    }

    /**
     * @return string
     */
    public function getIsError()
    {
      return $this->IsError;
    }

    /**
     * @param string $IsError
     * @return Tarifs
     */
    public function setIsError($IsError)
    {
      $this->IsError = $IsError;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->ErrorCode;
    }

    /**
     * @param int $ErrorCode
     * @return Tarifs
     */
    public function setErrorCode($ErrorCode)
    {
      $this->ErrorCode = $ErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
      return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return Tarifs
     */
    public function setErrorMessage($ErrorMessage)
    {
      $this->ErrorMessage = $ErrorMessage;
      return $this;
    }

}
