<?php

class SparkWebService extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
  'Articles' => '\\Articles',
  'Clients' => '\\Clients',
  'Tarifs' => '\\Tarifs',
  'GetArticles' => '\\GetArticles',
  'GetArticlesResponse' => '\\GetArticlesResponse',
  'GetArticle' => '\\GetArticle',
  'GetArticleResponse' => '\\GetArticleResponse',
  'UpdateArticle' => '\\UpdateArticle',
  'UpdateArticleResponse' => '\\UpdateArticleResponse',
  'CreateClient' => '\\CreateClient',
  'CreateClientResponse' => '\\CreateClientResponse',
  'DoesClientExist' => '\\DoesClientExist',
  'DoesClientExistResponse' => '\\DoesClientExistResponse',
  'UpdateClient' => '\\UpdateClient',
  'UpdateClientResponse' => '\\UpdateClientResponse',
  'GetClient' => '\\GetClient',
  'GetClientResponse' => '\\GetClientResponse',
  'GetClients' => '\\GetClients',
  'GetClientsResponse' => '\\GetClientsResponse',
  'CreateOrder' => '\\CreateOrder',
  'CreateOrderResponse' => '\\CreateOrderResponse',
  'CreateOrderLine' => '\\CreateOrderLine',
  'CreateOrderLineResponse' => '\\CreateOrderLineResponse',
  'ValidateOrder' => '\\ValidateOrder',
  'ValidateOrderResponse' => '\\ValidateOrderResponse',
  'GetOrder' => '\\GetOrder',
  'GetOrderResponse' => '\\GetOrderResponse',
  'LinkClient' => '\\LinkClient',
  'LinkClientResponse' => '\\LinkClientResponse',
  'GetTarifs' => '\\GetTarifs',
  'GetTarifsResponse' => '\\GetTarifsResponse',
  'UpdateEmail' => '\\UpdateEmail',
  'UpdateEmailResponse' => '\\UpdateEmailResponse',
  'GetContacts' => '\\GetContacts',
  'GetContactsResponse' => '\\GetContactsResponse',
  'Property' => '\\Property',
  'ServiceFailure' => '\\ServiceFailure',
);

    /**
     * @param string $wsdl The wsdl file to use
     * @param array $options A array of config values
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
  'features' => 1,
), $options);
      if (!$wsdl) {
        $wsdl = 'http://gspk-dev.greenspark.fr:9000/jsb-ws/SparkWeb?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetArticles $GetArticles
     * @return GetArticlesResponse
     */
    public function GetArticles(GetArticles $GetArticles)
    {
      return $this->__soapCall('GetArticles', array($GetArticles));
    }

    /**
     * @param GetArticle $GetArticle
     * @return GetArticleResponse
     */
    public function GetArticle(GetArticle $GetArticle)
    {
      return $this->__soapCall('GetArticle', array($GetArticle));
    }

    /**
     * @param UpdateArticle $UpdateArticle
     * @return UpdateArticleResponse
     */
    public function UpdateArticle(UpdateArticle $UpdateArticle)
    {
      return $this->__soapCall('UpdateArticle', array($UpdateArticle));
    }

    /**
     * @param CreateClient $CreateClient
     * @return CreateClientResponse
     */
    public function CreateClient(CreateClient $CreateClient)
    {
      return $this->__soapCall('CreateClient', array($CreateClient));
    }

    /**
     * @param DoesClientExist $DoesClientExist
     * @return DoesClientExistResponse
     */
    public function DoesClientExist(DoesClientExist $DoesClientExist)
    {
      return $this->__soapCall('DoesClientExist', array($DoesClientExist));
    }

    /**
     * @param UpdateClient $UpdateClient
     * @return UpdateClientResponse
     */
    public function UpdateClient(UpdateClient $UpdateClient)
    {
      return $this->__soapCall('UpdateClient', array($UpdateClient));
    }

    /**
     * @param GetClient $GetClient
     * @return GetClientResponse
     */
    public function GetClient(GetClient $GetClient)
    {
      return $this->__soapCall('GetClient', array($GetClient));
    }

    /**
     * @param GetClients $GetClients
     * @return GetClientsResponse
     */
    public function GetClients(GetClients $GetClients)
    {
      return $this->__soapCall('GetClients', array($GetClients));
    }

    /**
     * @param CreateOrder $CreateOrder
     * @return CreateOrderResponse
     */
    public function CreateOrder(CreateOrder $CreateOrder)
    {
      return $this->__soapCall('CreateOrder', array($CreateOrder));
    }

    /**
     * @param CreateOrderLine $CreateOrderLine
     * @return CreateOrderLineResponse
     */
    public function CreateOrderLine(CreateOrderLine $CreateOrderLine)
    {
      return $this->__soapCall('CreateOrderLine', array($CreateOrderLine));
    }

    /**
     * @param ValidateOrder $ValidateOrder
     * @return ValidateOrderResponse
     */
    public function ValidateOrder(ValidateOrder $ValidateOrder)
    {
      return $this->__soapCall('ValidateOrder', array($ValidateOrder));
    }

    /**
     * @param GetOrder $GetOrder
     * @return GetOrderResponse
     */
    public function GetOrder(GetOrder $GetOrder)
    {
      return $this->__soapCall('GetOrder', array($GetOrder));
    }

    /**
     * @param LinkClient $LinkClient
     * @return LinkClientResponse
     */
    public function LinkClient(LinkClient $LinkClient)
    {
      return $this->__soapCall('LinkClient', array($LinkClient));
    }

    /**
     * @param GetTarifs $GetTarifs
     * @return GetTarifsResponse
     */
    public function GetTarifs(GetTarifs $GetTarifs)
    {
      return $this->__soapCall('GetTarifs', array($GetTarifs));
    }

    /**
     * @param UpdateEmail $UpdateEmail
     * @return UpdateEmailResponse
     */
    public function UpdateEmail(UpdateEmail $UpdateEmail)
    {
      return $this->__soapCall('UpdateEmail', array($UpdateEmail));
    }

    /**
     * @param GetContacts $GetContacts
     * @return GetContactsResponse
     */
    public function GetContacts(GetContacts $GetContacts)
    {
      return $this->__soapCall('GetContacts', array($GetContacts));
    }

}
