<?php

class GetOrderResponse
{

    /**
     * @var string $IsError
     */
    protected $IsError = null;

    /**
     * @var int $ErrorCode
     */
    protected $ErrorCode = null;

    /**
     * @var string $ErrorMessage
     */
    protected $ErrorMessage = null;

    /**
     * @var string $WebOrderId
     */
    protected $WebOrderId = null;

    /**
     * @var string $OrderNumber
     */
    protected $OrderNumber = null;

    /**
     * @var string $OrderStatus
     */
    protected $OrderStatus = null;

    /**
     * @var string $PackageStatus
     */
    protected $PackageStatus = null;

    /**
     * @var int $PackageCount
     */
    protected $PackageCount = null;

    /**
     * @var string $InvoiceNumber
     */
    protected $InvoiceNumber = null;

    /**
     * @var \DateTime $InvoiceDate
     */
    protected $InvoiceDate = null;

    /**
     * @var \DateTime $InvoiceDueDate
     */
    protected $InvoiceDueDate = null;

    /**
     * @var \DateTime $DateExpedPrev
     */
    protected $DateExpedPrev = null;

    /**
     * @var string $Transporteur
     */
    protected $Transporteur = null;

    /**
     * @var string $TrackingNumber
     */
    protected $TrackingNumber = null;

    /**
     * @param string $IsError
     * @param int $ErrorCode
     * @param string $ErrorMessage
     * @param string $WebOrderId
     * @param string $OrderNumber
     * @param string $OrderStatus
     * @param string $PackageStatus
     * @param int $PackageCount
     * @param string $InvoiceNumber
     * @param \DateTime $InvoiceDate
     * @param \DateTime $InvoiceDueDate
     * @param \DateTime $DateExpedPrev
     * @param string $Transporteur
     * @param string $TrackingNumber
     */
    public function __construct($IsError, $ErrorCode, $ErrorMessage, $WebOrderId, $OrderNumber, $OrderStatus, $PackageStatus, $PackageCount, $InvoiceNumber, \DateTime $InvoiceDate, \DateTime $InvoiceDueDate, \DateTime $DateExpedPrev, $Transporteur, $TrackingNumber)
    {
      $this->IsError = $IsError;
      $this->ErrorCode = $ErrorCode;
      $this->ErrorMessage = $ErrorMessage;
      $this->WebOrderId = $WebOrderId;
      $this->OrderNumber = $OrderNumber;
      $this->OrderStatus = $OrderStatus;
      $this->PackageStatus = $PackageStatus;
      $this->PackageCount = $PackageCount;
      $this->InvoiceNumber = $InvoiceNumber;
      $this->InvoiceDate = $InvoiceDate->format(\DateTime::ATOM);
      $this->InvoiceDueDate = $InvoiceDueDate->format(\DateTime::ATOM);
      $this->DateExpedPrev = $DateExpedPrev->format(\DateTime::ATOM);
      $this->Transporteur = $Transporteur;
      $this->TrackingNumber = $TrackingNumber;
    }

    /**
     * @return string
     */
    public function getIsError()
    {
      return $this->IsError;
    }

    /**
     * @param string $IsError
     * @return GetOrderResponse
     */
    public function setIsError($IsError)
    {
      $this->IsError = $IsError;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->ErrorCode;
    }

    /**
     * @param int $ErrorCode
     * @return GetOrderResponse
     */
    public function setErrorCode($ErrorCode)
    {
      $this->ErrorCode = $ErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
      return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetOrderResponse
     */
    public function setErrorMessage($ErrorMessage)
    {
      $this->ErrorMessage = $ErrorMessage;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebOrderId()
    {
      return $this->WebOrderId;
    }

    /**
     * @param string $WebOrderId
     * @return GetOrderResponse
     */
    public function setWebOrderId($WebOrderId)
    {
      $this->WebOrderId = $WebOrderId;
      return $this;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
      return $this->OrderNumber;
    }

    /**
     * @param string $OrderNumber
     * @return GetOrderResponse
     */
    public function setOrderNumber($OrderNumber)
    {
      $this->OrderNumber = $OrderNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getOrderStatus()
    {
      return $this->OrderStatus;
    }

    /**
     * @param string $OrderStatus
     * @return GetOrderResponse
     */
    public function setOrderStatus($OrderStatus)
    {
      $this->OrderStatus = $OrderStatus;
      return $this;
    }

    /**
     * @return string
     */
    public function getPackageStatus()
    {
      return $this->PackageStatus;
    }

    /**
     * @param string $PackageStatus
     * @return GetOrderResponse
     */
    public function setPackageStatus($PackageStatus)
    {
      $this->PackageStatus = $PackageStatus;
      return $this;
    }

    /**
     * @return int
     */
    public function getPackageCount()
    {
      return $this->PackageCount;
    }

    /**
     * @param int $PackageCount
     * @return GetOrderResponse
     */
    public function setPackageCount($PackageCount)
    {
      $this->PackageCount = $PackageCount;
      return $this;
    }

    /**
     * @return string
     */
    public function getInvoiceNumber()
    {
      return $this->InvoiceNumber;
    }

    /**
     * @param string $InvoiceNumber
     * @return GetOrderResponse
     */
    public function setInvoiceNumber($InvoiceNumber)
    {
      $this->InvoiceNumber = $InvoiceNumber;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getInvoiceDate()
    {
      if ($this->InvoiceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->InvoiceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $InvoiceDate
     * @return GetOrderResponse
     */
    public function setInvoiceDate(\DateTime $InvoiceDate)
    {
      $this->InvoiceDate = $InvoiceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getInvoiceDueDate()
    {
      if ($this->InvoiceDueDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->InvoiceDueDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $InvoiceDueDate
     * @return GetOrderResponse
     */
    public function setInvoiceDueDate(\DateTime $InvoiceDueDate)
    {
      $this->InvoiceDueDate = $InvoiceDueDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateExpedPrev()
    {
      if ($this->DateExpedPrev == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateExpedPrev);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateExpedPrev
     * @return GetOrderResponse
     */
    public function setDateExpedPrev(\DateTime $DateExpedPrev)
    {
      $this->DateExpedPrev = $DateExpedPrev->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getTransporteur()
    {
      return $this->Transporteur;
    }

    /**
     * @param string $Transporteur
     * @return GetOrderResponse
     */
    public function setTransporteur($Transporteur)
    {
      $this->Transporteur = $Transporteur;
      return $this;
    }

    /**
     * @return string
     */
    public function getTrackingNumber()
    {
      return $this->TrackingNumber;
    }

    /**
     * @param string $TrackingNumber
     * @return GetOrderResponse
     */
    public function setTrackingNumber($TrackingNumber)
    {
      $this->TrackingNumber = $TrackingNumber;
      return $this;
    }

}
