<?php

class GetArticles
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $WebArticleId
     */
    protected $WebArticleId = null;

    /**
     * @var \DateTime $StartDate
     */
    protected $StartDate = null;

    /**
     * @var \DateTime $EndDate
     */
    protected $EndDate = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $WebArticleId
     * @param \DateTime $StartDate
     * @param \DateTime $EndDate
     */
    public function __construct($HashKey, $PublicKey, $WebArticleId, \DateTime $StartDate, \DateTime $EndDate)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->WebArticleId = $WebArticleId;
      $this->StartDate = $StartDate->format(\DateTime::ATOM);
      $this->EndDate = $EndDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return GetArticles
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return GetArticles
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebArticleId()
    {
      return $this->WebArticleId;
    }

    /**
     * @param string $WebArticleId
     * @return GetArticles
     */
    public function setWebArticleId($WebArticleId)
    {
      $this->WebArticleId = $WebArticleId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->StartDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->StartDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $StartDate
     * @return GetArticles
     */
    public function setStartDate(\DateTime $StartDate)
    {
      $this->StartDate = $StartDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->EndDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->EndDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $EndDate
     * @return GetArticles
     */
    public function setEndDate(\DateTime $EndDate)
    {
      $this->EndDate = $EndDate->format(\DateTime::ATOM);
      return $this;
    }

}
