<?php

class DoesClientExistResponse
{

    /**
     * @var string $IsError
     */
    protected $IsError = null;

    /**
     * @var int $ErrorCode
     */
    protected $ErrorCode = null;

    /**
     * @var string $ErrorMessage
     */
    protected $ErrorMessage = null;

    /**
     * @var string $ClientId
     */
    protected $ClientId = null;

    /**
     * @var string $Name
     */
    protected $Name = null;

    /**
     * @param string $IsError
     * @param int $ErrorCode
     * @param string $ErrorMessage
     * @param string $ClientId
     * @param string $Name
     */
    public function __construct($IsError, $ErrorCode, $ErrorMessage, $ClientId, $Name)
    {
      $this->IsError = $IsError;
      $this->ErrorCode = $ErrorCode;
      $this->ErrorMessage = $ErrorMessage;
      $this->ClientId = $ClientId;
      $this->Name = $Name;
    }

    /**
     * @return string
     */
    public function getIsError()
    {
      return $this->IsError;
    }

    /**
     * @param string $IsError
     * @return DoesClientExistResponse
     */
    public function setIsError($IsError)
    {
      $this->IsError = $IsError;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->ErrorCode;
    }

    /**
     * @param int $ErrorCode
     * @return DoesClientExistResponse
     */
    public function setErrorCode($ErrorCode)
    {
      $this->ErrorCode = $ErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
      return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return DoesClientExistResponse
     */
    public function setErrorMessage($ErrorMessage)
    {
      $this->ErrorMessage = $ErrorMessage;
      return $this;
    }

    /**
     * @return string
     */
    public function getClientId()
    {
      return $this->ClientId;
    }

    /**
     * @param string $ClientId
     * @return DoesClientExistResponse
     */
    public function setClientId($ClientId)
    {
      $this->ClientId = $ClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
      return $this->Name;
    }

    /**
     * @param string $Name
     * @return DoesClientExistResponse
     */
    public function setName($Name)
    {
      $this->Name = $Name;
      return $this;
    }

}
