<?php

class DoesClientExist
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $Email
     */
    protected $Email = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $Email
     */
    public function __construct($HashKey, $PublicKey, $Email)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->Email = $Email;
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return DoesClientExist
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return DoesClientExist
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
      return $this->Email;
    }

    /**
     * @param string $Email
     * @return DoesClientExist
     */
    public function setEmail($Email)
    {
      $this->Email = $Email;
      return $this;
    }

}
