<?php

class CreateOrderLine
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $WebOrderId
     */
    protected $WebOrderId = null;

    /**
     * @var string $WebArticleId
     */
    protected $WebArticleId = null;

    /**
     * @var float $UnitPriceET
     */
    protected $UnitPriceET = null;

    /**
     * @var float $UnitPriceIT
     */
    protected $UnitPriceIT = null;

    /**
     * @var float $DiscountAmount
     */
    protected $DiscountAmount = null;

    /**
     * @var float $DiscountPercent
     */
    protected $DiscountPercent = null;

    /**
     * @var float $Quantity
     */
    protected $Quantity = null;

    /**
     * @var float $AmountET
     */
    protected $AmountET = null;

    /**
     * @var string $AmountIT
     */
    protected $AmountIT = null;

    /**
     * @var string $PromotionCode
     */
    protected $PromotionCode = null;

    /**
     * @var string $PromotionDescription
     */
    protected $PromotionDescription = null;

    /**
     * @var \DateTime $PromotionValidityDate
     */
    protected $PromotionValidityDate = null;

    /**
     * @var string $UnitAlternative
     */
    protected $UnitAlternative = null;

    /**
     * @var int $QteGratuite
     */
    protected $QteGratuite = null;

    /**
     * @var int $CodeGratuit
     */
    protected $CodeGratuit = null;

    /**
     * @var float $Remise2
     */
    protected $Remise2 = null;

    /**
     * @var float $Remise3
     */
    protected $Remise3 = null;

    /**
     * @var float $RemiseManuelle
     */
    protected $RemiseManuelle = null;

    /**
     * @var string $TexteExterne
     */
    protected $TexteExterne = null;

    /**
     * @var string $TexteInterne
     */
    protected $TexteInterne = null;

    /**
     * @var float $PrixHorsPort
     */
    protected $PrixHorsPort = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $WebOrderId
     * @param string $WebArticleId
     * @param float $UnitPriceET
     * @param float $UnitPriceIT
     * @param float $DiscountAmount
     * @param float $DiscountPercent
     * @param float $Quantity
     * @param float $AmountET
     * @param string $AmountIT
     * @param string $PromotionCode
     * @param string $PromotionDescription
     * @param \DateTime $PromotionValidityDate
     * @param string $UnitAlternative
     * @param int $QteGratuite
     * @param int $CodeGratuit
     * @param float $Remise2
     * @param float $Remise3
     * @param float $RemiseManuelle
     * @param string $TexteExterne
     * @param string $TexteInterne
     * @param float $PrixHorsPort
     */
    public function __construct($HashKey, $PublicKey, $WebOrderId, $WebArticleId, $UnitPriceET, $UnitPriceIT, $DiscountAmount, $DiscountPercent, $Quantity, $AmountET, $AmountIT, $PromotionCode, $PromotionDescription, \DateTime $PromotionValidityDate, $UnitAlternative, $QteGratuite, $CodeGratuit, $Remise2, $Remise3, $RemiseManuelle, $TexteExterne, $TexteInterne, $PrixHorsPort)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->WebOrderId = $WebOrderId;
      $this->WebArticleId = $WebArticleId;
      $this->UnitPriceET = $UnitPriceET;
      $this->UnitPriceIT = $UnitPriceIT;
      $this->DiscountAmount = $DiscountAmount;
      $this->DiscountPercent = $DiscountPercent;
      $this->Quantity = $Quantity;
      $this->AmountET = $AmountET;
      $this->AmountIT = $AmountIT;
      $this->PromotionCode = $PromotionCode;
      $this->PromotionDescription = $PromotionDescription;
      $this->PromotionValidityDate = $PromotionValidityDate->format(\DateTime::ATOM);
      $this->UnitAlternative = $UnitAlternative;
      $this->QteGratuite = $QteGratuite;
      $this->CodeGratuit = $CodeGratuit;
      $this->Remise2 = $Remise2;
      $this->Remise3 = $Remise3;
      $this->RemiseManuelle = $RemiseManuelle;
      $this->TexteExterne = $TexteExterne;
      $this->TexteInterne = $TexteInterne;
      $this->PrixHorsPort = $PrixHorsPort;
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return CreateOrderLine
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return CreateOrderLine
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebOrderId()
    {
      return $this->WebOrderId;
    }

    /**
     * @param string $WebOrderId
     * @return CreateOrderLine
     */
    public function setWebOrderId($WebOrderId)
    {
      $this->WebOrderId = $WebOrderId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebArticleId()
    {
      return $this->WebArticleId;
    }

    /**
     * @param string $WebArticleId
     * @return CreateOrderLine
     */
    public function setWebArticleId($WebArticleId)
    {
      $this->WebArticleId = $WebArticleId;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitPriceET()
    {
      return $this->UnitPriceET;
    }

    /**
     * @param float $UnitPriceET
     * @return CreateOrderLine
     */
    public function setUnitPriceET($UnitPriceET)
    {
      $this->UnitPriceET = $UnitPriceET;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitPriceIT()
    {
      return $this->UnitPriceIT;
    }

    /**
     * @param float $UnitPriceIT
     * @return CreateOrderLine
     */
    public function setUnitPriceIT($UnitPriceIT)
    {
      $this->UnitPriceIT = $UnitPriceIT;
      return $this;
    }

    /**
     * @return float
     */
    public function getDiscountAmount()
    {
      return $this->DiscountAmount;
    }

    /**
     * @param float $DiscountAmount
     * @return CreateOrderLine
     */
    public function setDiscountAmount($DiscountAmount)
    {
      $this->DiscountAmount = $DiscountAmount;
      return $this;
    }

    /**
     * @return float
     */
    public function getDiscountPercent()
    {
      return $this->DiscountPercent;
    }

    /**
     * @param float $DiscountPercent
     * @return CreateOrderLine
     */
    public function setDiscountPercent($DiscountPercent)
    {
      $this->DiscountPercent = $DiscountPercent;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
      return $this->Quantity;
    }

    /**
     * @param float $Quantity
     * @return CreateOrderLine
     */
    public function setQuantity($Quantity)
    {
      $this->Quantity = $Quantity;
      return $this;
    }

    /**
     * @return float
     */
    public function getAmountET()
    {
      return $this->AmountET;
    }

    /**
     * @param float $AmountET
     * @return CreateOrderLine
     */
    public function setAmountET($AmountET)
    {
      $this->AmountET = $AmountET;
      return $this;
    }

    /**
     * @return string
     */
    public function getAmountIT()
    {
      return $this->AmountIT;
    }

    /**
     * @param string $AmountIT
     * @return CreateOrderLine
     */
    public function setAmountIT($AmountIT)
    {
      $this->AmountIT = $AmountIT;
      return $this;
    }

    /**
     * @return string
     */
    public function getPromotionCode()
    {
      return $this->PromotionCode;
    }

    /**
     * @param string $PromotionCode
     * @return CreateOrderLine
     */
    public function setPromotionCode($PromotionCode)
    {
      $this->PromotionCode = $PromotionCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getPromotionDescription()
    {
      return $this->PromotionDescription;
    }

    /**
     * @param string $PromotionDescription
     * @return CreateOrderLine
     */
    public function setPromotionDescription($PromotionDescription)
    {
      $this->PromotionDescription = $PromotionDescription;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getPromotionValidityDate()
    {
      if ($this->PromotionValidityDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->PromotionValidityDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $PromotionValidityDate
     * @return CreateOrderLine
     */
    public function setPromotionValidityDate(\DateTime $PromotionValidityDate)
    {
      $this->PromotionValidityDate = $PromotionValidityDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getUnitAlternative()
    {
      return $this->UnitAlternative;
    }

    /**
     * @param string $UnitAlternative
     * @return CreateOrderLine
     */
    public function setUnitAlternative($UnitAlternative)
    {
      $this->UnitAlternative = $UnitAlternative;
      return $this;
    }

    /**
     * @return int
     */
    public function getQteGratuite()
    {
      return $this->QteGratuite;
    }

    /**
     * @param int $QteGratuite
     * @return CreateOrderLine
     */
    public function setQteGratuite($QteGratuite)
    {
      $this->QteGratuite = $QteGratuite;
      return $this;
    }

    /**
     * @return int
     */
    public function getCodeGratuit()
    {
      return $this->CodeGratuit;
    }

    /**
     * @param int $CodeGratuit
     * @return CreateOrderLine
     */
    public function setCodeGratuit($CodeGratuit)
    {
      $this->CodeGratuit = $CodeGratuit;
      return $this;
    }

    /**
     * @return float
     */
    public function getRemise2()
    {
      return $this->Remise2;
    }

    /**
     * @param float $Remise2
     * @return CreateOrderLine
     */
    public function setRemise2($Remise2)
    {
      $this->Remise2 = $Remise2;
      return $this;
    }

    /**
     * @return float
     */
    public function getRemise3()
    {
      return $this->Remise3;
    }

    /**
     * @param float $Remise3
     * @return CreateOrderLine
     */
    public function setRemise3($Remise3)
    {
      $this->Remise3 = $Remise3;
      return $this;
    }

    /**
     * @return float
     */
    public function getRemiseManuelle()
    {
      return $this->RemiseManuelle;
    }

    /**
     * @param float $RemiseManuelle
     * @return CreateOrderLine
     */
    public function setRemiseManuelle($RemiseManuelle)
    {
      $this->RemiseManuelle = $RemiseManuelle;
      return $this;
    }

    /**
     * @return string
     */
    public function getTexteExterne()
    {
      return $this->TexteExterne;
    }

    /**
     * @param string $TexteExterne
     * @return CreateOrderLine
     */
    public function setTexteExterne($TexteExterne)
    {
      $this->TexteExterne = $TexteExterne;
      return $this;
    }

    /**
     * @return string
     */
    public function getTexteInterne()
    {
      return $this->TexteInterne;
    }

    /**
     * @param string $TexteInterne
     * @return CreateOrderLine
     */
    public function setTexteInterne($TexteInterne)
    {
      $this->TexteInterne = $TexteInterne;
      return $this;
    }

    /**
     * @return float
     */
    public function getPrixHorsPort()
    {
      return $this->PrixHorsPort;
    }

    /**
     * @param float $PrixHorsPort
     * @return CreateOrderLine
     */
    public function setPrixHorsPort($PrixHorsPort)
    {
      $this->PrixHorsPort = $PrixHorsPort;
      return $this;
    }

}
