<?php

class UpdateEmail
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $ClientId
     */
    protected $ClientId = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @var string $Email
     */
    protected $Email = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $ClientId
     * @param string $WebClientId
     * @param string $Email
     */
    public function __construct($HashKey, $PublicKey, $ClientId, $WebClientId, $Email)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->ClientId = $ClientId;
      $this->WebClientId = $WebClientId;
      $this->Email = $Email;
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return UpdateEmail
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return UpdateEmail
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getClientId()
    {
      return $this->ClientId;
    }

    /**
     * @param string $ClientId
     * @return UpdateEmail
     */
    public function setClientId($ClientId)
    {
      $this->ClientId = $ClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return UpdateEmail
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
      return $this->Email;
    }

    /**
     * @param string $Email
     * @return UpdateEmail
     */
    public function setEmail($Email)
    {
      $this->Email = $Email;
      return $this;
    }

}
