<?php

class UpdateArticle
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $Code
     */
    protected $Code = null;

    /**
     * @var string $WebCode
     */
    protected $WebCode = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $Code
     * @param string $WebCode
     */
    public function __construct($HashKey, $PublicKey, $Code, $WebCode)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->Code = $Code;
      $this->WebCode = $WebCode;
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return UpdateArticle
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return UpdateArticle
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getCode()
    {
      return $this->Code;
    }

    /**
     * @param string $Code
     * @return UpdateArticle
     */
    public function setCode($Code)
    {
      $this->Code = $Code;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebCode()
    {
      return $this->WebCode;
    }

    /**
     * @param string $WebCode
     * @return UpdateArticle
     */
    public function setWebCode($WebCode)
    {
      $this->WebCode = $WebCode;
      return $this;
    }

}
