<?php

class ServiceFailure
{

    /**
     * @var string $message
     */
    protected $message = null;

    /**
     * @var Property $properties
     */
    protected $properties = null;

    /**
     * @var int $errorCode
     */
    protected $errorCode = null;

    /**
     * @var int $sourceErrorCode
     */
    protected $sourceErrorCode = null;

    /**
     * @var string $source
     */
    protected $source = null;

    /**
     * @var \DateTime $timestamp
     */
    protected $timestamp = null;

    /**
     * @var string $failureId
     */
    protected $failureId = null;

    /**
     * @param string $message
     * @param Property $properties
     * @param int $errorCode
     * @param int $sourceErrorCode
     * @param string $source
     * @param \DateTime $timestamp
     * @param string $failureId
     */
    public function __construct($message, $properties, $errorCode, $sourceErrorCode, $source, \DateTime $timestamp, $failureId)
    {
      $this->message = $message;
      $this->properties = $properties;
      $this->errorCode = $errorCode;
      $this->sourceErrorCode = $sourceErrorCode;
      $this->source = $source;
      $this->timestamp = $timestamp->format(\DateTime::ATOM);
      $this->failureId = $failureId;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
      return $this->message;
    }

    /**
     * @param string $message
     * @return ServiceFailure
     */
    public function setMessage($message)
    {
      $this->message = $message;
      return $this;
    }

    /**
     * @return Property
     */
    public function getProperties()
    {
      return $this->properties;
    }

    /**
     * @param Property $properties
     * @return ServiceFailure
     */
    public function setProperties($properties)
    {
      $this->properties = $properties;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->errorCode;
    }

    /**
     * @param int $errorCode
     * @return ServiceFailure
     */
    public function setErrorCode($errorCode)
    {
      $this->errorCode = $errorCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getSourceErrorCode()
    {
      return $this->sourceErrorCode;
    }

    /**
     * @param int $sourceErrorCode
     * @return ServiceFailure
     */
    public function setSourceErrorCode($sourceErrorCode)
    {
      $this->sourceErrorCode = $sourceErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
      return $this->source;
    }

    /**
     * @param string $source
     * @return ServiceFailure
     */
    public function setSource($source)
    {
      $this->source = $source;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTimestamp()
    {
      if ($this->timestamp == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->timestamp);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $timestamp
     * @return ServiceFailure
     */
    public function setTimestamp(\DateTime $timestamp)
    {
      $this->timestamp = $timestamp->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getFailureId()
    {
      return $this->failureId;
    }

    /**
     * @param string $failureId
     * @return ServiceFailure
     */
    public function setFailureId($failureId)
    {
      $this->failureId = $failureId;
      return $this;
    }

}
