<?php

class LinkClient
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $ClientId
     */
    protected $ClientId = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $ClientId
     * @param string $WebClientId
     */
    public function __construct($HashKey, $PublicKey, $ClientId, $WebClientId)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->ClientId = $ClientId;
      $this->WebClientId = $WebClientId;
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return LinkClient
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return LinkClient
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getClientId()
    {
      return $this->ClientId;
    }

    /**
     * @param string $ClientId
     * @return LinkClient
     */
    public function setClientId($ClientId)
    {
      $this->ClientId = $ClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return LinkClient
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

}
