<?php

class GetOrder
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $WebOrderId
     */
    protected $WebOrderId = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $WebOrderId
     */
    public function __construct($HashKey, $PublicKey, $WebOrderId)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->WebOrderId = $WebOrderId;
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return GetOrder
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return GetOrder
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebOrderId()
    {
      return $this->WebOrderId;
    }

    /**
     * @param string $WebOrderId
     * @return GetOrder
     */
    public function setWebOrderId($WebOrderId)
    {
      $this->WebOrderId = $WebOrderId;
      return $this;
    }

}
