<?php

class GetClientResponse
{

    /**
     * @var string $IsError
     */
    protected $IsError = null;

    /**
     * @var int $ErrorCode
     */
    protected $ErrorCode = null;

    /**
     * @var string $ErrorMessage
     */
    protected $ErrorMessage = null;

    /**
     * @var string $ClientId
     */
    protected $ClientId = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @var string $Name
     */
    protected $Name = null;

    /**
     * @var string $Email
     */
    protected $Email = null;

    /**
     * @var \DateTime $BirthDate
     */
    protected $BirthDate = null;

    /**
     * @var string $SiretNumber
     */
    protected $SiretNumber = null;

    /**
     * @var string $IntraComVat
     */
    protected $IntraComVat = null;

    /**
     * @var string $IsInactive
     */
    protected $IsInactive = null;

    /**
     * @var string $WebGroupClient
     */
    protected $WebGroupClient = null;

    /**
     * @param string $IsError
     * @param int $ErrorCode
     * @param string $ErrorMessage
     * @param string $ClientId
     * @param string $WebClientId
     * @param string $Name
     * @param string $Email
     * @param \DateTime $BirthDate
     * @param string $SiretNumber
     * @param string $IntraComVat
     * @param string $IsInactive
     * @param string $WebGroupClient
     */
    public function __construct($IsError, $ErrorCode, $ErrorMessage, $ClientId, $WebClientId, $Name, $Email, \DateTime $BirthDate, $SiretNumber, $IntraComVat, $IsInactive, $WebGroupClient)
    {
      $this->IsError = $IsError;
      $this->ErrorCode = $ErrorCode;
      $this->ErrorMessage = $ErrorMessage;
      $this->ClientId = $ClientId;
      $this->WebClientId = $WebClientId;
      $this->Name = $Name;
      $this->Email = $Email;
      $this->BirthDate = $BirthDate->format(\DateTime::ATOM);
      $this->SiretNumber = $SiretNumber;
      $this->IntraComVat = $IntraComVat;
      $this->IsInactive = $IsInactive;
      $this->WebGroupClient = $WebGroupClient;
    }

    /**
     * @return string
     */
    public function getIsError()
    {
      return $this->IsError;
    }

    /**
     * @param string $IsError
     * @return GetClientResponse
     */
    public function setIsError($IsError)
    {
      $this->IsError = $IsError;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->ErrorCode;
    }

    /**
     * @param int $ErrorCode
     * @return GetClientResponse
     */
    public function setErrorCode($ErrorCode)
    {
      $this->ErrorCode = $ErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
      return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetClientResponse
     */
    public function setErrorMessage($ErrorMessage)
    {
      $this->ErrorMessage = $ErrorMessage;
      return $this;
    }

    /**
     * @return string
     */
    public function getClientId()
    {
      return $this->ClientId;
    }

    /**
     * @param string $ClientId
     * @return GetClientResponse
     */
    public function setClientId($ClientId)
    {
      $this->ClientId = $ClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return GetClientResponse
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
      return $this->Name;
    }

    /**
     * @param string $Name
     * @return GetClientResponse
     */
    public function setName($Name)
    {
      $this->Name = $Name;
      return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
      return $this->Email;
    }

    /**
     * @param string $Email
     * @return GetClientResponse
     */
    public function setEmail($Email)
    {
      $this->Email = $Email;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBirthDate()
    {
      if ($this->BirthDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->BirthDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $BirthDate
     * @return GetClientResponse
     */
    public function setBirthDate(\DateTime $BirthDate)
    {
      $this->BirthDate = $BirthDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getSiretNumber()
    {
      return $this->SiretNumber;
    }

    /**
     * @param string $SiretNumber
     * @return GetClientResponse
     */
    public function setSiretNumber($SiretNumber)
    {
      $this->SiretNumber = $SiretNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getIntraComVat()
    {
      return $this->IntraComVat;
    }

    /**
     * @param string $IntraComVat
     * @return GetClientResponse
     */
    public function setIntraComVat($IntraComVat)
    {
      $this->IntraComVat = $IntraComVat;
      return $this;
    }

    /**
     * @return string
     */
    public function getIsInactive()
    {
      return $this->IsInactive;
    }

    /**
     * @param string $IsInactive
     * @return GetClientResponse
     */
    public function setIsInactive($IsInactive)
    {
      $this->IsInactive = $IsInactive;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebGroupClient()
    {
      return $this->WebGroupClient;
    }

    /**
     * @param string $WebGroupClient
     * @return GetClientResponse
     */
    public function setWebGroupClient($WebGroupClient)
    {
      $this->WebGroupClient = $WebGroupClient;
      return $this;
    }

}
