<?php

class GetArticlesResponse
{

    /**
     * @var Articles $Articles
     */
    protected $Articles = null;

    /**
     * @var string $IsError
     */
    protected $IsError = null;

    /**
     * @var int $ErrorCode
     */
    protected $ErrorCode = null;

    /**
     * @var string $ErrorMessage
     */
    protected $ErrorMessage = null;

    /**
     * @param Articles $Articles
     * @param string $IsError
     * @param int $ErrorCode
     * @param string $ErrorMessage
     */
    public function __construct($Articles, $IsError, $ErrorCode, $ErrorMessage)
    {
      $this->Articles = $Articles;
      $this->IsError = $IsError;
      $this->ErrorCode = $ErrorCode;
      $this->ErrorMessage = $ErrorMessage;
    }

    /**
     * @return Articles
     */
    public function getArticles()
    {
      return $this->Articles;
    }

    /**
     * @param Articles $Articles
     * @return GetArticlesResponse
     */
    public function setArticles($Articles)
    {
      $this->Articles = $Articles;
      return $this;
    }

    /**
     * @return string
     */
    public function getIsError()
    {
      return $this->IsError;
    }

    /**
     * @param string $IsError
     * @return GetArticlesResponse
     */
    public function setIsError($IsError)
    {
      $this->IsError = $IsError;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->ErrorCode;
    }

    /**
     * @param int $ErrorCode
     * @return GetArticlesResponse
     */
    public function setErrorCode($ErrorCode)
    {
      $this->ErrorCode = $ErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
      return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetArticlesResponse
     */
    public function setErrorMessage($ErrorMessage)
    {
      $this->ErrorMessage = $ErrorMessage;
      return $this;
    }

}
