<?php

class GetAddressResponse
{

    /**
     * @var string $IsError
     */
    protected $IsError = null;

    /**
     * @var int $ErrorCode
     */
    protected $ErrorCode = null;

    /**
     * @var string $ErrorMessage
     */
    protected $ErrorMessage = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @var string $WebAddressId
     */
    protected $WebAddressId = null;

    /**
     * @var string $AddressAlias
     */
    protected $AddressAlias = null;

    /**
     * @var string $AddressLine1
     */
    protected $AddressLine1 = null;

    /**
     * @var string $AddressLine2
     */
    protected $AddressLine2 = null;

    /**
     * @var string $Building
     */
    protected $Building = null;

    /**
     * @var string $PostalCode
     */
    protected $PostalCode = null;

    /**
     * @var string $City
     */
    protected $City = null;

    /**
     * @var string $Country
     */
    protected $Country = null;

    /**
     * @var string $PhoneNumber
     */
    protected $PhoneNumber = null;

    /**
     * @var string $IntraComVat
     */
    protected $IntraComVat = null;

    /**
     * @var string $SiretNumber
     */
    protected $SiretNumber = null;

    /**
     * @var string $DeliveryComment
     */
    protected $DeliveryComment = null;

    /**
     * @var \DateTime $LastUpdate
     */
    protected $LastUpdate = null;

    /**
     * @var \DateTime $WebCreationDate
     */
    protected $WebCreationDate = null;

    /**
     * @param string $IsError
     * @param int $ErrorCode
     * @param string $ErrorMessage
     * @param string $WebClientId
     * @param string $WebAddressId
     * @param string $AddressAlias
     * @param string $AddressLine1
     * @param string $AddressLine2
     * @param string $Building
     * @param string $PostalCode
     * @param string $City
     * @param string $Country
     * @param string $PhoneNumber
     * @param string $IntraComVat
     * @param string $SiretNumber
     * @param string $DeliveryComment
     * @param \DateTime $LastUpdate
     * @param \DateTime $WebCreationDate
     */
    public function __construct($IsError, $ErrorCode, $ErrorMessage, $WebClientId, $WebAddressId, $AddressAlias, $AddressLine1, $AddressLine2, $Building, $PostalCode, $City, $Country, $PhoneNumber, $IntraComVat, $SiretNumber, $DeliveryComment, \DateTime $LastUpdate, \DateTime $WebCreationDate)
    {
      $this->IsError = $IsError;
      $this->ErrorCode = $ErrorCode;
      $this->ErrorMessage = $ErrorMessage;
      $this->WebClientId = $WebClientId;
      $this->WebAddressId = $WebAddressId;
      $this->AddressAlias = $AddressAlias;
      $this->AddressLine1 = $AddressLine1;
      $this->AddressLine2 = $AddressLine2;
      $this->Building = $Building;
      $this->PostalCode = $PostalCode;
      $this->City = $City;
      $this->Country = $Country;
      $this->PhoneNumber = $PhoneNumber;
      $this->IntraComVat = $IntraComVat;
      $this->SiretNumber = $SiretNumber;
      $this->DeliveryComment = $DeliveryComment;
      $this->LastUpdate = $LastUpdate->format(\DateTime::ATOM);
      $this->WebCreationDate = $WebCreationDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getIsError()
    {
      return $this->IsError;
    }

    /**
     * @param string $IsError
     * @return GetAddressResponse
     */
    public function setIsError($IsError)
    {
      $this->IsError = $IsError;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->ErrorCode;
    }

    /**
     * @param int $ErrorCode
     * @return GetAddressResponse
     */
    public function setErrorCode($ErrorCode)
    {
      $this->ErrorCode = $ErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
      return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetAddressResponse
     */
    public function setErrorMessage($ErrorMessage)
    {
      $this->ErrorMessage = $ErrorMessage;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return GetAddressResponse
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebAddressId()
    {
      return $this->WebAddressId;
    }

    /**
     * @param string $WebAddressId
     * @return GetAddressResponse
     */
    public function setWebAddressId($WebAddressId)
    {
      $this->WebAddressId = $WebAddressId;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressAlias()
    {
      return $this->AddressAlias;
    }

    /**
     * @param string $AddressAlias
     * @return GetAddressResponse
     */
    public function setAddressAlias($AddressAlias)
    {
      $this->AddressAlias = $AddressAlias;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine1()
    {
      return $this->AddressLine1;
    }

    /**
     * @param string $AddressLine1
     * @return GetAddressResponse
     */
    public function setAddressLine1($AddressLine1)
    {
      $this->AddressLine1 = $AddressLine1;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine2()
    {
      return $this->AddressLine2;
    }

    /**
     * @param string $AddressLine2
     * @return GetAddressResponse
     */
    public function setAddressLine2($AddressLine2)
    {
      $this->AddressLine2 = $AddressLine2;
      return $this;
    }

    /**
     * @return string
     */
    public function getBuilding()
    {
      return $this->Building;
    }

    /**
     * @param string $Building
     * @return GetAddressResponse
     */
    public function setBuilding($Building)
    {
      $this->Building = $Building;
      return $this;
    }

    /**
     * @return string
     */
    public function getPostalCode()
    {
      return $this->PostalCode;
    }

    /**
     * @param string $PostalCode
     * @return GetAddressResponse
     */
    public function setPostalCode($PostalCode)
    {
      $this->PostalCode = $PostalCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
      return $this->City;
    }

    /**
     * @param string $City
     * @return GetAddressResponse
     */
    public function setCity($City)
    {
      $this->City = $City;
      return $this;
    }

    /**
     * @return string
     */
    public function getCountry()
    {
      return $this->Country;
    }

    /**
     * @param string $Country
     * @return GetAddressResponse
     */
    public function setCountry($Country)
    {
      $this->Country = $Country;
      return $this;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
      return $this->PhoneNumber;
    }

    /**
     * @param string $PhoneNumber
     * @return GetAddressResponse
     */
    public function setPhoneNumber($PhoneNumber)
    {
      $this->PhoneNumber = $PhoneNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getIntraComVat()
    {
      return $this->IntraComVat;
    }

    /**
     * @param string $IntraComVat
     * @return GetAddressResponse
     */
    public function setIntraComVat($IntraComVat)
    {
      $this->IntraComVat = $IntraComVat;
      return $this;
    }

    /**
     * @return string
     */
    public function getSiretNumber()
    {
      return $this->SiretNumber;
    }

    /**
     * @param string $SiretNumber
     * @return GetAddressResponse
     */
    public function setSiretNumber($SiretNumber)
    {
      $this->SiretNumber = $SiretNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryComment()
    {
      return $this->DeliveryComment;
    }

    /**
     * @param string $DeliveryComment
     * @return GetAddressResponse
     */
    public function setDeliveryComment($DeliveryComment)
    {
      $this->DeliveryComment = $DeliveryComment;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdate()
    {
      if ($this->LastUpdate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdate
     * @return GetAddressResponse
     */
    public function setLastUpdate(\DateTime $LastUpdate)
    {
      $this->LastUpdate = $LastUpdate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getWebCreationDate()
    {
      if ($this->WebCreationDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->WebCreationDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $WebCreationDate
     * @return GetAddressResponse
     */
    public function setWebCreationDate(\DateTime $WebCreationDate)
    {
      $this->WebCreationDate = $WebCreationDate->format(\DateTime::ATOM);
      return $this;
    }

}
