<?php

class GetAddress
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @var string $WebAddressId
     */
    protected $WebAddressId = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $WebClientId
     * @param string $WebAddressId
     */
    public function __construct($HashKey, $PublicKey, $WebClientId, $WebAddressId)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->WebClientId = $WebClientId;
      $this->WebAddressId = $WebAddressId;
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return GetAddress
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return GetAddress
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return GetAddress
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebAddressId()
    {
      return $this->WebAddressId;
    }

    /**
     * @param string $WebAddressId
     * @return GetAddress
     */
    public function setWebAddressId($WebAddressId)
    {
      $this->WebAddressId = $WebAddressId;
      return $this;
    }

}
