<?php

class CreateOrder
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $WebOrderId
     */
    protected $WebOrderId = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @var \DateTime $OrderDate
     */
    protected $OrderDate = null;

    /**
     * @var string $AddressAlias
     */
    protected $AddressAlias = null;

    /**
     * @var string $AddressLine1
     */
    protected $AddressLine1 = null;

    /**
     * @var string $AddressLine2
     */
    protected $AddressLine2 = null;

    /**
     * @var string $Building
     */
    protected $Building = null;

    /**
     * @var string $PostalCode
     */
    protected $PostalCode = null;

    /**
     * @var string $City
     */
    protected $City = null;

    /**
     * @var string $Country
     */
    protected $Country = null;

    /**
     * @var string $PhoneNumber
     */
    protected $PhoneNumber = null;

    /**
     * @var string $DeliveryComment
     */
    protected $DeliveryComment = null;

    /**
     * @var string $BesoinControle
     */
    protected $BesoinControle = null;

    /**
     * @var string $TexteGeneral
     */
    protected $TexteGeneral = null;

    /**
     * @var string $TexteFactProforma
     */
    protected $TexteFactProforma = null;

    /**
     * @var string $TexteBonPrepa
     */
    protected $TexteBonPrepa = null;

    /**
     * @var string $CodeClientFact
     */
    protected $CodeClientFact = null;

    /**
     * @var string $CodeClientLivre
     */
    protected $CodeClientLivre = null;

    /**
     * @var string $CodeClientPayeur
     */
    protected $CodeClientPayeur = null;

    /**
     * @var \DateTime $DateLivrSouhai
     */
    protected $DateLivrSouhai = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $WebOrderId
     * @param string $WebClientId
     * @param \DateTime $OrderDate
     * @param string $AddressAlias
     * @param string $AddressLine1
     * @param string $AddressLine2
     * @param string $Building
     * @param string $PostalCode
     * @param string $City
     * @param string $Country
     * @param string $PhoneNumber
     * @param string $DeliveryComment
     * @param string $BesoinControle
     * @param string $TexteGeneral
     * @param string $TexteFactProforma
     * @param string $TexteBonPrepa
     * @param string $CodeClientFact
     * @param string $CodeClientLivre
     * @param string $CodeClientPayeur
     * @param \DateTime $DateLivrSouhai
     */
    public function __construct($HashKey, $PublicKey, $WebOrderId, $WebClientId, \DateTime $OrderDate, $AddressAlias, $AddressLine1, $AddressLine2, $Building, $PostalCode, $City, $Country, $PhoneNumber, $DeliveryComment, $BesoinControle, $TexteGeneral, $TexteFactProforma, $TexteBonPrepa, $CodeClientFact, $CodeClientLivre, $CodeClientPayeur, \DateTime $DateLivrSouhai)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->WebOrderId = $WebOrderId;
      $this->WebClientId = $WebClientId;
      $this->OrderDate = $OrderDate->format(\DateTime::ATOM);
      $this->AddressAlias = $AddressAlias;
      $this->AddressLine1 = $AddressLine1;
      $this->AddressLine2 = $AddressLine2;
      $this->Building = $Building;
      $this->PostalCode = $PostalCode;
      $this->City = $City;
      $this->Country = $Country;
      $this->PhoneNumber = $PhoneNumber;
      $this->DeliveryComment = $DeliveryComment;
      $this->BesoinControle = $BesoinControle;
      $this->TexteGeneral = $TexteGeneral;
      $this->TexteFactProforma = $TexteFactProforma;
      $this->TexteBonPrepa = $TexteBonPrepa;
      $this->CodeClientFact = $CodeClientFact;
      $this->CodeClientLivre = $CodeClientLivre;
      $this->CodeClientPayeur = $CodeClientPayeur;
      $this->DateLivrSouhai = $DateLivrSouhai->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return CreateOrder
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return CreateOrder
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebOrderId()
    {
      return $this->WebOrderId;
    }

    /**
     * @param string $WebOrderId
     * @return CreateOrder
     */
    public function setWebOrderId($WebOrderId)
    {
      $this->WebOrderId = $WebOrderId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return CreateOrder
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getOrderDate()
    {
      if ($this->OrderDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->OrderDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $OrderDate
     * @return CreateOrder
     */
    public function setOrderDate(\DateTime $OrderDate)
    {
      $this->OrderDate = $OrderDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressAlias()
    {
      return $this->AddressAlias;
    }

    /**
     * @param string $AddressAlias
     * @return CreateOrder
     */
    public function setAddressAlias($AddressAlias)
    {
      $this->AddressAlias = $AddressAlias;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine1()
    {
      return $this->AddressLine1;
    }

    /**
     * @param string $AddressLine1
     * @return CreateOrder
     */
    public function setAddressLine1($AddressLine1)
    {
      $this->AddressLine1 = $AddressLine1;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine2()
    {
      return $this->AddressLine2;
    }

    /**
     * @param string $AddressLine2
     * @return CreateOrder
     */
    public function setAddressLine2($AddressLine2)
    {
      $this->AddressLine2 = $AddressLine2;
      return $this;
    }

    /**
     * @return string
     */
    public function getBuilding()
    {
      return $this->Building;
    }

    /**
     * @param string $Building
     * @return CreateOrder
     */
    public function setBuilding($Building)
    {
      $this->Building = $Building;
      return $this;
    }

    /**
     * @return string
     */
    public function getPostalCode()
    {
      return $this->PostalCode;
    }

    /**
     * @param string $PostalCode
     * @return CreateOrder
     */
    public function setPostalCode($PostalCode)
    {
      $this->PostalCode = $PostalCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
      return $this->City;
    }

    /**
     * @param string $City
     * @return CreateOrder
     */
    public function setCity($City)
    {
      $this->City = $City;
      return $this;
    }

    /**
     * @return string
     */
    public function getCountry()
    {
      return $this->Country;
    }

    /**
     * @param string $Country
     * @return CreateOrder
     */
    public function setCountry($Country)
    {
      $this->Country = $Country;
      return $this;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
      return $this->PhoneNumber;
    }

    /**
     * @param string $PhoneNumber
     * @return CreateOrder
     */
    public function setPhoneNumber($PhoneNumber)
    {
      $this->PhoneNumber = $PhoneNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryComment()
    {
      return $this->DeliveryComment;
    }

    /**
     * @param string $DeliveryComment
     * @return CreateOrder
     */
    public function setDeliveryComment($DeliveryComment)
    {
      $this->DeliveryComment = $DeliveryComment;
      return $this;
    }

    /**
     * @return string
     */
    public function getBesoinControle()
    {
      return $this->BesoinControle;
    }

    /**
     * @param string $BesoinControle
     * @return CreateOrder
     */
    public function setBesoinControle($BesoinControle)
    {
      $this->BesoinControle = $BesoinControle;
      return $this;
    }

    /**
     * @return string
     */
    public function getTexteGeneral()
    {
      return $this->TexteGeneral;
    }

    /**
     * @param string $TexteGeneral
     * @return CreateOrder
     */
    public function setTexteGeneral($TexteGeneral)
    {
      $this->TexteGeneral = $TexteGeneral;
      return $this;
    }

    /**
     * @return string
     */
    public function getTexteFactProforma()
    {
      return $this->TexteFactProforma;
    }

    /**
     * @param string $TexteFactProforma
     * @return CreateOrder
     */
    public function setTexteFactProforma($TexteFactProforma)
    {
      $this->TexteFactProforma = $TexteFactProforma;
      return $this;
    }

    /**
     * @return string
     */
    public function getTexteBonPrepa()
    {
      return $this->TexteBonPrepa;
    }

    /**
     * @param string $TexteBonPrepa
     * @return CreateOrder
     */
    public function setTexteBonPrepa($TexteBonPrepa)
    {
      $this->TexteBonPrepa = $TexteBonPrepa;
      return $this;
    }

    /**
     * @return string
     */
    public function getCodeClientFact()
    {
      return $this->CodeClientFact;
    }

    /**
     * @param string $CodeClientFact
     * @return CreateOrder
     */
    public function setCodeClientFact($CodeClientFact)
    {
      $this->CodeClientFact = $CodeClientFact;
      return $this;
    }

    /**
     * @return string
     */
    public function getCodeClientLivre()
    {
      return $this->CodeClientLivre;
    }

    /**
     * @param string $CodeClientLivre
     * @return CreateOrder
     */
    public function setCodeClientLivre($CodeClientLivre)
    {
      $this->CodeClientLivre = $CodeClientLivre;
      return $this;
    }

    /**
     * @return string
     */
    public function getCodeClientPayeur()
    {
      return $this->CodeClientPayeur;
    }

    /**
     * @param string $CodeClientPayeur
     * @return CreateOrder
     */
    public function setCodeClientPayeur($CodeClientPayeur)
    {
      $this->CodeClientPayeur = $CodeClientPayeur;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateLivrSouhai()
    {
      if ($this->DateLivrSouhai == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateLivrSouhai);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateLivrSouhai
     * @return CreateOrder
     */
    public function setDateLivrSouhai(\DateTime $DateLivrSouhai)
    {
      $this->DateLivrSouhai = $DateLivrSouhai->format(\DateTime::ATOM);
      return $this;
    }

}
