<?php

class CreateClient
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @var string $Email
     */
    protected $Email = null;

    /**
     * @var int $Civility
     */
    protected $Civility = null;

    /**
     * @var string $FirstName
     */
    protected $FirstName = null;

    /**
     * @var string $LastName
     */
    protected $LastName = null;

    /**
     * @var \DateTime $BirthDate
     */
    protected $BirthDate = null;

    /**
     * @var \DateTime $LastUpdate
     */
    protected $LastUpdate = null;

    /**
     * @var \DateTime $WebCreationDate
     */
    protected $WebCreationDate = null;

    /**
     * @var string $SiretNumber
     */
    protected $SiretNumber = null;

    /**
     * @var string $IntraComVat
     */
    protected $IntraComVat = null;

    /**
     * @var string $AdressLine1
     */
    protected $AdressLine1 = null;

    /**
     * @var string $AddressLine2
     */
    protected $AddressLine2 = null;

    /**
     * @var string $Building
     */
    protected $Building = null;

    /**
     * @var string $PostalCode
     */
    protected $PostalCode = null;

    /**
     * @var string $City
     */
    protected $City = null;

    /**
     * @var string $Country
     */
    protected $Country = null;

    /**
     * @var string $PhoneNumber
     */
    protected $PhoneNumber = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $WebClientId
     * @param string $Email
     * @param int $Civility
     * @param string $FirstName
     * @param string $LastName
     * @param \DateTime $BirthDate
     * @param \DateTime $LastUpdate
     * @param \DateTime $WebCreationDate
     * @param string $SiretNumber
     * @param string $IntraComVat
     * @param string $AdressLine1
     * @param string $AddressLine2
     * @param string $Building
     * @param string $PostalCode
     * @param string $City
     * @param string $Country
     * @param string $PhoneNumber
     */
    public function __construct($HashKey, $PublicKey, $WebClientId, $Email, $Civility, $FirstName, $LastName, \DateTime $BirthDate, \DateTime $LastUpdate, \DateTime $WebCreationDate, $SiretNumber, $IntraComVat, $AdressLine1, $AddressLine2, $Building, $PostalCode, $City, $Country, $PhoneNumber)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->WebClientId = $WebClientId;
      $this->Email = $Email;
      $this->Civility = $Civility;
      $this->FirstName = $FirstName;
      $this->LastName = $LastName;
      $this->BirthDate = $BirthDate->format(\DateTime::ATOM);
      $this->LastUpdate = $LastUpdate->format(\DateTime::ATOM);
      $this->WebCreationDate = $WebCreationDate->format(\DateTime::ATOM);
      $this->SiretNumber = $SiretNumber;
      $this->IntraComVat = $IntraComVat;
      $this->AdressLine1 = $AdressLine1;
      $this->AddressLine2 = $AddressLine2;
      $this->Building = $Building;
      $this->PostalCode = $PostalCode;
      $this->City = $City;
      $this->Country = $Country;
      $this->PhoneNumber = $PhoneNumber;
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return CreateClient
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return CreateClient
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return CreateClient
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
      return $this->Email;
    }

    /**
     * @param string $Email
     * @return CreateClient
     */
    public function setEmail($Email)
    {
      $this->Email = $Email;
      return $this;
    }

    /**
     * @return int
     */
    public function getCivility()
    {
      return $this->Civility;
    }

    /**
     * @param int $Civility
     * @return CreateClient
     */
    public function setCivility($Civility)
    {
      $this->Civility = $Civility;
      return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
      return $this->FirstName;
    }

    /**
     * @param string $FirstName
     * @return CreateClient
     */
    public function setFirstName($FirstName)
    {
      $this->FirstName = $FirstName;
      return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
      return $this->LastName;
    }

    /**
     * @param string $LastName
     * @return CreateClient
     */
    public function setLastName($LastName)
    {
      $this->LastName = $LastName;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBirthDate()
    {
      if ($this->BirthDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->BirthDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $BirthDate
     * @return CreateClient
     */
    public function setBirthDate(\DateTime $BirthDate)
    {
      $this->BirthDate = $BirthDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdate()
    {
      if ($this->LastUpdate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdate
     * @return CreateClient
     */
    public function setLastUpdate(\DateTime $LastUpdate)
    {
      $this->LastUpdate = $LastUpdate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getWebCreationDate()
    {
      if ($this->WebCreationDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->WebCreationDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $WebCreationDate
     * @return CreateClient
     */
    public function setWebCreationDate(\DateTime $WebCreationDate)
    {
      $this->WebCreationDate = $WebCreationDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getSiretNumber()
    {
      return $this->SiretNumber;
    }

    /**
     * @param string $SiretNumber
     * @return CreateClient
     */
    public function setSiretNumber($SiretNumber)
    {
      $this->SiretNumber = $SiretNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getIntraComVat()
    {
      return $this->IntraComVat;
    }

    /**
     * @param string $IntraComVat
     * @return CreateClient
     */
    public function setIntraComVat($IntraComVat)
    {
      $this->IntraComVat = $IntraComVat;
      return $this;
    }

    /**
     * @return string
     */
    public function getAdressLine1()
    {
      return $this->AdressLine1;
    }

    /**
     * @param string $AdressLine1
     * @return CreateClient
     */
    public function setAdressLine1($AdressLine1)
    {
      $this->AdressLine1 = $AdressLine1;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine2()
    {
      return $this->AddressLine2;
    }

    /**
     * @param string $AddressLine2
     * @return CreateClient
     */
    public function setAddressLine2($AddressLine2)
    {
      $this->AddressLine2 = $AddressLine2;
      return $this;
    }

    /**
     * @return string
     */
    public function getBuilding()
    {
      return $this->Building;
    }

    /**
     * @param string $Building
     * @return CreateClient
     */
    public function setBuilding($Building)
    {
      $this->Building = $Building;
      return $this;
    }

    /**
     * @return string
     */
    public function getPostalCode()
    {
      return $this->PostalCode;
    }

    /**
     * @param string $PostalCode
     * @return CreateClient
     */
    public function setPostalCode($PostalCode)
    {
      $this->PostalCode = $PostalCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
      return $this->City;
    }

    /**
     * @param string $City
     * @return CreateClient
     */
    public function setCity($City)
    {
      $this->City = $City;
      return $this;
    }

    /**
     * @return string
     */
    public function getCountry()
    {
      return $this->Country;
    }

    /**
     * @param string $Country
     * @return CreateClient
     */
    public function setCountry($Country)
    {
      $this->Country = $Country;
      return $this;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
      return $this->PhoneNumber;
    }

    /**
     * @param string $PhoneNumber
     * @return CreateClient
     */
    public function setPhoneNumber($PhoneNumber)
    {
      $this->PhoneNumber = $PhoneNumber;
      return $this;
    }

}
