<?php

class CreateAddress
{

    /**
     * @var string $HashKey
     */
    protected $HashKey = null;

    /**
     * @var string $PublicKey
     */
    protected $PublicKey = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @var string $WebAddressId
     */
    protected $WebAddressId = null;

    /**
     * @var string $Civility
     */
    protected $Civility = null;

    /**
     * @var string $AddressAlias
     */
    protected $AddressAlias = null;

    /**
     * @var string $AddressLine1
     */
    protected $AddressLine1 = null;

    /**
     * @var string $AddressLine2
     */
    protected $AddressLine2 = null;

    /**
     * @var string $Building
     */
    protected $Building = null;

    /**
     * @var string $PostalCode
     */
    protected $PostalCode = null;

    /**
     * @var string $City
     */
    protected $City = null;

    /**
     * @var string $Country
     */
    protected $Country = null;

    /**
     * @var string $PhoneNumber
     */
    protected $PhoneNumber = null;

    /**
     * @var string $IntraComVat
     */
    protected $IntraComVat = null;

    /**
     * @var string $SiretNumber
     */
    protected $SiretNumber = null;

    /**
     * @var string $DeliveryComment
     */
    protected $DeliveryComment = null;

    /**
     * @var string $IsDeliveryAddress
     */
    protected $IsDeliveryAddress = null;

    /**
     * @var string $IsBillingAddress
     */
    protected $IsBillingAddress = null;

    /**
     * @var \DateTime $LastUpdate
     */
    protected $LastUpdate = null;

    /**
     * @var \DateTime $WebCreationDate
     */
    protected $WebCreationDate = null;

    /**
     * @param string $HashKey
     * @param string $PublicKey
     * @param string $WebClientId
     * @param string $WebAddressId
     * @param string $Civility
     * @param string $AddressAlias
     * @param string $AddressLine1
     * @param string $AddressLine2
     * @param string $Building
     * @param string $PostalCode
     * @param string $City
     * @param string $Country
     * @param string $PhoneNumber
     * @param string $IntraComVat
     * @param string $SiretNumber
     * @param string $DeliveryComment
     * @param string $IsDeliveryAddress
     * @param string $IsBillingAddress
     * @param \DateTime $LastUpdate
     * @param \DateTime $WebCreationDate
     */
    public function __construct($HashKey, $PublicKey, $WebClientId, $WebAddressId, $Civility, $AddressAlias, $AddressLine1, $AddressLine2, $Building, $PostalCode, $City, $Country, $PhoneNumber, $IntraComVat, $SiretNumber, $DeliveryComment, $IsDeliveryAddress, $IsBillingAddress, \DateTime $LastUpdate, \DateTime $WebCreationDate)
    {
      $this->HashKey = $HashKey;
      $this->PublicKey = $PublicKey;
      $this->WebClientId = $WebClientId;
      $this->WebAddressId = $WebAddressId;
      $this->Civility = $Civility;
      $this->AddressAlias = $AddressAlias;
      $this->AddressLine1 = $AddressLine1;
      $this->AddressLine2 = $AddressLine2;
      $this->Building = $Building;
      $this->PostalCode = $PostalCode;
      $this->City = $City;
      $this->Country = $Country;
      $this->PhoneNumber = $PhoneNumber;
      $this->IntraComVat = $IntraComVat;
      $this->SiretNumber = $SiretNumber;
      $this->DeliveryComment = $DeliveryComment;
      $this->IsDeliveryAddress = $IsDeliveryAddress;
      $this->IsBillingAddress = $IsBillingAddress;
      $this->LastUpdate = $LastUpdate->format(\DateTime::ATOM);
      $this->WebCreationDate = $WebCreationDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getHashKey()
    {
      return $this->HashKey;
    }

    /**
     * @param string $HashKey
     * @return CreateAddress
     */
    public function setHashKey($HashKey)
    {
      $this->HashKey = $HashKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getPublicKey()
    {
      return $this->PublicKey;
    }

    /**
     * @param string $PublicKey
     * @return CreateAddress
     */
    public function setPublicKey($PublicKey)
    {
      $this->PublicKey = $PublicKey;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return CreateAddress
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebAddressId()
    {
      return $this->WebAddressId;
    }

    /**
     * @param string $WebAddressId
     * @return CreateAddress
     */
    public function setWebAddressId($WebAddressId)
    {
      $this->WebAddressId = $WebAddressId;
      return $this;
    }

    /**
     * @return string
     */
    public function getCivility()
    {
      return $this->Civility;
    }

    /**
     * @param string $Civility
     * @return CreateAddress
     */
    public function setCivility($Civility)
    {
      $this->Civility = $Civility;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressAlias()
    {
      return $this->AddressAlias;
    }

    /**
     * @param string $AddressAlias
     * @return CreateAddress
     */
    public function setAddressAlias($AddressAlias)
    {
      $this->AddressAlias = $AddressAlias;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine1()
    {
      return $this->AddressLine1;
    }

    /**
     * @param string $AddressLine1
     * @return CreateAddress
     */
    public function setAddressLine1($AddressLine1)
    {
      $this->AddressLine1 = $AddressLine1;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine2()
    {
      return $this->AddressLine2;
    }

    /**
     * @param string $AddressLine2
     * @return CreateAddress
     */
    public function setAddressLine2($AddressLine2)
    {
      $this->AddressLine2 = $AddressLine2;
      return $this;
    }

    /**
     * @return string
     */
    public function getBuilding()
    {
      return $this->Building;
    }

    /**
     * @param string $Building
     * @return CreateAddress
     */
    public function setBuilding($Building)
    {
      $this->Building = $Building;
      return $this;
    }

    /**
     * @return string
     */
    public function getPostalCode()
    {
      return $this->PostalCode;
    }

    /**
     * @param string $PostalCode
     * @return CreateAddress
     */
    public function setPostalCode($PostalCode)
    {
      $this->PostalCode = $PostalCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
      return $this->City;
    }

    /**
     * @param string $City
     * @return CreateAddress
     */
    public function setCity($City)
    {
      $this->City = $City;
      return $this;
    }

    /**
     * @return string
     */
    public function getCountry()
    {
      return $this->Country;
    }

    /**
     * @param string $Country
     * @return CreateAddress
     */
    public function setCountry($Country)
    {
      $this->Country = $Country;
      return $this;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
      return $this->PhoneNumber;
    }

    /**
     * @param string $PhoneNumber
     * @return CreateAddress
     */
    public function setPhoneNumber($PhoneNumber)
    {
      $this->PhoneNumber = $PhoneNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getIntraComVat()
    {
      return $this->IntraComVat;
    }

    /**
     * @param string $IntraComVat
     * @return CreateAddress
     */
    public function setIntraComVat($IntraComVat)
    {
      $this->IntraComVat = $IntraComVat;
      return $this;
    }

    /**
     * @return string
     */
    public function getSiretNumber()
    {
      return $this->SiretNumber;
    }

    /**
     * @param string $SiretNumber
     * @return CreateAddress
     */
    public function setSiretNumber($SiretNumber)
    {
      $this->SiretNumber = $SiretNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryComment()
    {
      return $this->DeliveryComment;
    }

    /**
     * @param string $DeliveryComment
     * @return CreateAddress
     */
    public function setDeliveryComment($DeliveryComment)
    {
      $this->DeliveryComment = $DeliveryComment;
      return $this;
    }

    /**
     * @return string
     */
    public function getIsDeliveryAddress()
    {
      return $this->IsDeliveryAddress;
    }

    /**
     * @param string $IsDeliveryAddress
     * @return CreateAddress
     */
    public function setIsDeliveryAddress($IsDeliveryAddress)
    {
      $this->IsDeliveryAddress = $IsDeliveryAddress;
      return $this;
    }

    /**
     * @return string
     */
    public function getIsBillingAddress()
    {
      return $this->IsBillingAddress;
    }

    /**
     * @param string $IsBillingAddress
     * @return CreateAddress
     */
    public function setIsBillingAddress($IsBillingAddress)
    {
      $this->IsBillingAddress = $IsBillingAddress;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdate()
    {
      if ($this->LastUpdate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdate
     * @return CreateAddress
     */
    public function setLastUpdate(\DateTime $LastUpdate)
    {
      $this->LastUpdate = $LastUpdate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getWebCreationDate()
    {
      if ($this->WebCreationDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->WebCreationDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $WebCreationDate
     * @return CreateAddress
     */
    public function setWebCreationDate(\DateTime $WebCreationDate)
    {
      $this->WebCreationDate = $WebCreationDate->format(\DateTime::ATOM);
      return $this;
    }

}
