<?php

class Clients
{

    /**
     * @var string $ClientId
     */
    protected $ClientId = null;

    /**
     * @var string $WebClientId
     */
    protected $WebClientId = null;

    /**
     * @var string $Name
     */
    protected $Name = null;

    /**
     * @var string $Email
     */
    protected $Email = null;

    /**
     * @var \DateTime $BirthDate
     */
    protected $BirthDate = null;

    /**
     * @var string $SiretNumber
     */
    protected $SiretNumber = null;

    /**
     * @var string $IntraComVat
     */
    protected $IntraComVat = null;

    /**
     * @var string $IsInactive
     */
    protected $IsInactive = null;

    /**
     * @var string $WebGroupClient
     */
    protected $WebGroupClient = null;

    /**
     * @var string $Adresse
     */
    protected $Adresse = null;

    /**
     * @var string $CpltAdresse
     */
    protected $CpltAdresse = null;

    /**
     * @var string $InfosBat
     */
    protected $InfosBat = null;

    /**
     * @var string $IdRelais
     */
    protected $IdRelais = null;

    /**
     * @var string $CP
     */
    protected $CP = null;

    /**
     * @var string $Commune
     */
    protected $Commune = null;

    /**
     * @var string $Ville
     */
    protected $Ville = null;

    /**
     * @var string $PaysCode
     */
    protected $PaysCode = null;

    /**
     * @var string $PaysTitle
     */
    protected $PaysTitle = null;

    /**
     * @var int $TVACode
     */
    protected $TVACode = null;

    /**
     * @var float $TVATaux
     */
    protected $TVATaux = null;

    /**
     * @var string $TVATitle
     */
    protected $TVATitle = null;

    /**
     * @var string $ModeDePaiementCode
     */
    protected $ModeDePaiementCode = null;

    /**
     * @var string $ModeDePaiementTitle
     */
    protected $ModeDePaiementTitle = null;

    /**
     * @var string $CondPaiementCode
     */
    protected $CondPaiementCode = null;

    /**
     * @var string $CondPaiementTitle
     */
    protected $CondPaiementTitle = null;

    /**
     * @var int $CategorieCode
     */
    protected $CategorieCode = null;

    /**
     * @var string $CategorieTitle
     */
    protected $CategorieTitle = null;

    /**
     * @var float $EncoursCommande
     */
    protected $EncoursCommande = null;

    /**
     * @var float $EncoursComptable
     */
    protected $EncoursComptable = null;

    /**
     * @var float $EncoursTotal
     */
    protected $EncoursTotal = null;

    /**
     * @var string $SecteurComCode
     */
    protected $SecteurComCode = null;

    /**
     * @var string $SecteurComTitle
     */
    protected $SecteurComTitle = null;

    /**
     * @var string $MarcheComCode
     */
    protected $MarcheComCode = null;

    /**
     * @var string $MarcheComTitle
     */
    protected $MarcheComTitle = null;

    /**
     * @var string $RegionComLib
     */
    protected $RegionComLib = null;

    /**
     * @var string $RegionComTitle
     */
    protected $RegionComTitle = null;

    /**
     * @var int $ModeComCode
     */
    protected $ModeComCode = null;

    /**
     * @var string $ModeComTitle
     */
    protected $ModeComTitle = null;

    /**
     * @var string $TelMobile
     */
    protected $TelMobile = null;

    /**
     * @var string $TelFixe
     */
    protected $TelFixe = null;

    /**
     * @var string $CommercialCode
     */
    protected $CommercialCode = null;

    /**
     * @var string $CommercialTitle
     */
    protected $CommercialTitle = null;

    /**
     * @var float $PerRemise
     */
    protected $PerRemise = null;

    /**
     * @var int $TarifCode
     */
    protected $TarifCode = null;

    /**
     * @var string $TarifTitle
     */
    protected $TarifTitle = null;

    /**
     * @var int $LangueCode
     */
    protected $LangueCode = null;

    /**
     * @var string $LangueTitle
     */
    protected $LangueTitle = null;

    /**
     * @var string $IsError
     */
    protected $IsError = null;

    /**
     * @var int $ErrorCode
     */
    protected $ErrorCode = null;

    /**
     * @var string $ErrorMessage
     */
    protected $ErrorMessage = null;

    /**
     * @param string $ClientId
     * @param string $WebClientId
     * @param string $Name
     * @param string $Email
     * @param \DateTime $BirthDate
     * @param string $SiretNumber
     * @param string $IntraComVat
     * @param string $IsInactive
     * @param string $WebGroupClient
     * @param string $Adresse
     * @param string $CpltAdresse
     * @param string $InfosBat
     * @param string $IdRelais
     * @param string $CP
     * @param string $Commune
     * @param string $Ville
     * @param string $PaysCode
     * @param string $PaysTitle
     * @param int $TVACode
     * @param float $TVATaux
     * @param string $TVATitle
     * @param string $ModeDePaiementCode
     * @param string $ModeDePaiementTitle
     * @param string $CondPaiementCode
     * @param string $CondPaiementTitle
     * @param int $CategorieCode
     * @param string $CategorieTitle
     * @param float $EncoursCommande
     * @param float $EncoursComptable
     * @param float $EncoursTotal
     * @param string $SecteurComCode
     * @param string $SecteurComTitle
     * @param string $MarcheComCode
     * @param string $MarcheComTitle
     * @param string $RegionComLib
     * @param string $RegionComTitle
     * @param int $ModeComCode
     * @param string $ModeComTitle
     * @param string $TelMobile
     * @param string $TelFixe
     * @param string $CommercialCode
     * @param string $CommercialTitle
     * @param float $PerRemise
     * @param int $TarifCode
     * @param string $TarifTitle
     * @param int $LangueCode
     * @param string $LangueTitle
     * @param string $IsError
     * @param int $ErrorCode
     * @param string $ErrorMessage
     */
    public function __construct($ClientId, $WebClientId, $Name, $Email, \DateTime $BirthDate, $SiretNumber, $IntraComVat, $IsInactive, $WebGroupClient, $Adresse, $CpltAdresse, $InfosBat, $IdRelais, $CP, $Commune, $Ville, $PaysCode, $PaysTitle, $TVACode, $TVATaux, $TVATitle, $ModeDePaiementCode, $ModeDePaiementTitle, $CondPaiementCode, $CondPaiementTitle, $CategorieCode, $CategorieTitle, $EncoursCommande, $EncoursComptable, $EncoursTotal, $SecteurComCode, $SecteurComTitle, $MarcheComCode, $MarcheComTitle, $RegionComLib, $RegionComTitle, $ModeComCode, $ModeComTitle, $TelMobile, $TelFixe, $CommercialCode, $CommercialTitle, $PerRemise, $TarifCode, $TarifTitle, $LangueCode, $LangueTitle, $IsError, $ErrorCode, $ErrorMessage)
    {
      $this->ClientId = $ClientId;
      $this->WebClientId = $WebClientId;
      $this->Name = $Name;
      $this->Email = $Email;
      $this->BirthDate = $BirthDate->format(\DateTime::ATOM);
      $this->SiretNumber = $SiretNumber;
      $this->IntraComVat = $IntraComVat;
      $this->IsInactive = $IsInactive;
      $this->WebGroupClient = $WebGroupClient;
      $this->Adresse = $Adresse;
      $this->CpltAdresse = $CpltAdresse;
      $this->InfosBat = $InfosBat;
      $this->IdRelais = $IdRelais;
      $this->CP = $CP;
      $this->Commune = $Commune;
      $this->Ville = $Ville;
      $this->PaysCode = $PaysCode;
      $this->PaysTitle = $PaysTitle;
      $this->TVACode = $TVACode;
      $this->TVATaux = $TVATaux;
      $this->TVATitle = $TVATitle;
      $this->ModeDePaiementCode = $ModeDePaiementCode;
      $this->ModeDePaiementTitle = $ModeDePaiementTitle;
      $this->CondPaiementCode = $CondPaiementCode;
      $this->CondPaiementTitle = $CondPaiementTitle;
      $this->CategorieCode = $CategorieCode;
      $this->CategorieTitle = $CategorieTitle;
      $this->EncoursCommande = $EncoursCommande;
      $this->EncoursComptable = $EncoursComptable;
      $this->EncoursTotal = $EncoursTotal;
      $this->SecteurComCode = $SecteurComCode;
      $this->SecteurComTitle = $SecteurComTitle;
      $this->MarcheComCode = $MarcheComCode;
      $this->MarcheComTitle = $MarcheComTitle;
      $this->RegionComLib = $RegionComLib;
      $this->RegionComTitle = $RegionComTitle;
      $this->ModeComCode = $ModeComCode;
      $this->ModeComTitle = $ModeComTitle;
      $this->TelMobile = $TelMobile;
      $this->TelFixe = $TelFixe;
      $this->CommercialCode = $CommercialCode;
      $this->CommercialTitle = $CommercialTitle;
      $this->PerRemise = $PerRemise;
      $this->TarifCode = $TarifCode;
      $this->TarifTitle = $TarifTitle;
      $this->LangueCode = $LangueCode;
      $this->LangueTitle = $LangueTitle;
      $this->IsError = $IsError;
      $this->ErrorCode = $ErrorCode;
      $this->ErrorMessage = $ErrorMessage;
    }

    /**
     * @return string
     */
    public function getClientId()
    {
      return $this->ClientId;
    }

    /**
     * @param string $ClientId
     * @return Clients
     */
    public function setClientId($ClientId)
    {
      $this->ClientId = $ClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebClientId()
    {
      return $this->WebClientId;
    }

    /**
     * @param string $WebClientId
     * @return Clients
     */
    public function setWebClientId($WebClientId)
    {
      $this->WebClientId = $WebClientId;
      return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
      return $this->Name;
    }

    /**
     * @param string $Name
     * @return Clients
     */
    public function setName($Name)
    {
      $this->Name = $Name;
      return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
      return $this->Email;
    }

    /**
     * @param string $Email
     * @return Clients
     */
    public function setEmail($Email)
    {
      $this->Email = $Email;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBirthDate()
    {
      if ($this->BirthDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->BirthDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $BirthDate
     * @return Clients
     */
    public function setBirthDate(\DateTime $BirthDate)
    {
      $this->BirthDate = $BirthDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getSiretNumber()
    {
      return $this->SiretNumber;
    }

    /**
     * @param string $SiretNumber
     * @return Clients
     */
    public function setSiretNumber($SiretNumber)
    {
      $this->SiretNumber = $SiretNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getIntraComVat()
    {
      return $this->IntraComVat;
    }

    /**
     * @param string $IntraComVat
     * @return Clients
     */
    public function setIntraComVat($IntraComVat)
    {
      $this->IntraComVat = $IntraComVat;
      return $this;
    }

    /**
     * @return string
     */
    public function getIsInactive()
    {
      return $this->IsInactive;
    }

    /**
     * @param string $IsInactive
     * @return Clients
     */
    public function setIsInactive($IsInactive)
    {
      $this->IsInactive = $IsInactive;
      return $this;
    }

    /**
     * @return string
     */
    public function getWebGroupClient()
    {
      return $this->WebGroupClient;
    }

    /**
     * @param string $WebGroupClient
     * @return Clients
     */
    public function setWebGroupClient($WebGroupClient)
    {
      $this->WebGroupClient = $WebGroupClient;
      return $this;
    }

    /**
     * @return string
     */
    public function getAdresse()
    {
      return $this->Adresse;
    }

    /**
     * @param string $Adresse
     * @return Clients
     */
    public function setAdresse($Adresse)
    {
      $this->Adresse = $Adresse;
      return $this;
    }

    /**
     * @return string
     */
    public function getCpltAdresse()
    {
      return $this->CpltAdresse;
    }

    /**
     * @param string $CpltAdresse
     * @return Clients
     */
    public function setCpltAdresse($CpltAdresse)
    {
      $this->CpltAdresse = $CpltAdresse;
      return $this;
    }

    /**
     * @return string
     */
    public function getInfosBat()
    {
      return $this->InfosBat;
    }

    /**
     * @param string $InfosBat
     * @return Clients
     */
    public function setInfosBat($InfosBat)
    {
      $this->InfosBat = $InfosBat;
      return $this;
    }

    /**
     * @return string
     */
    public function getIdRelais()
    {
      return $this->IdRelais;
    }

    /**
     * @param string $IdRelais
     * @return Clients
     */
    public function setIdRelais($IdRelais)
    {
      $this->IdRelais = $IdRelais;
      return $this;
    }

    /**
     * @return string
     */
    public function getCP()
    {
      return $this->CP;
    }

    /**
     * @param string $CP
     * @return Clients
     */
    public function setCP($CP)
    {
      $this->CP = $CP;
      return $this;
    }

    /**
     * @return string
     */
    public function getCommune()
    {
      return $this->Commune;
    }

    /**
     * @param string $Commune
     * @return Clients
     */
    public function setCommune($Commune)
    {
      $this->Commune = $Commune;
      return $this;
    }

    /**
     * @return string
     */
    public function getVille()
    {
      return $this->Ville;
    }

    /**
     * @param string $Ville
     * @return Clients
     */
    public function setVille($Ville)
    {
      $this->Ville = $Ville;
      return $this;
    }

    /**
     * @return string
     */
    public function getPaysCode()
    {
      return $this->PaysCode;
    }

    /**
     * @param string $PaysCode
     * @return Clients
     */
    public function setPaysCode($PaysCode)
    {
      $this->PaysCode = $PaysCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getPaysTitle()
    {
      return $this->PaysTitle;
    }

    /**
     * @param string $PaysTitle
     * @return Clients
     */
    public function setPaysTitle($PaysTitle)
    {
      $this->PaysTitle = $PaysTitle;
      return $this;
    }

    /**
     * @return int
     */
    public function getTVACode()
    {
      return $this->TVACode;
    }

    /**
     * @param int $TVACode
     * @return Clients
     */
    public function setTVACode($TVACode)
    {
      $this->TVACode = $TVACode;
      return $this;
    }

    /**
     * @return float
     */
    public function getTVATaux()
    {
      return $this->TVATaux;
    }

    /**
     * @param float $TVATaux
     * @return Clients
     */
    public function setTVATaux($TVATaux)
    {
      $this->TVATaux = $TVATaux;
      return $this;
    }

    /**
     * @return string
     */
    public function getTVATitle()
    {
      return $this->TVATitle;
    }

    /**
     * @param string $TVATitle
     * @return Clients
     */
    public function setTVATitle($TVATitle)
    {
      $this->TVATitle = $TVATitle;
      return $this;
    }

    /**
     * @return string
     */
    public function getModeDePaiementCode()
    {
      return $this->ModeDePaiementCode;
    }

    /**
     * @param string $ModeDePaiementCode
     * @return Clients
     */
    public function setModeDePaiementCode($ModeDePaiementCode)
    {
      $this->ModeDePaiementCode = $ModeDePaiementCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getModeDePaiementTitle()
    {
      return $this->ModeDePaiementTitle;
    }

    /**
     * @param string $ModeDePaiementTitle
     * @return Clients
     */
    public function setModeDePaiementTitle($ModeDePaiementTitle)
    {
      $this->ModeDePaiementTitle = $ModeDePaiementTitle;
      return $this;
    }

    /**
     * @return string
     */
    public function getCondPaiementCode()
    {
      return $this->CondPaiementCode;
    }

    /**
     * @param string $CondPaiementCode
     * @return Clients
     */
    public function setCondPaiementCode($CondPaiementCode)
    {
      $this->CondPaiementCode = $CondPaiementCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCondPaiementTitle()
    {
      return $this->CondPaiementTitle;
    }

    /**
     * @param string $CondPaiementTitle
     * @return Clients
     */
    public function setCondPaiementTitle($CondPaiementTitle)
    {
      $this->CondPaiementTitle = $CondPaiementTitle;
      return $this;
    }

    /**
     * @return int
     */
    public function getCategorieCode()
    {
      return $this->CategorieCode;
    }

    /**
     * @param int $CategorieCode
     * @return Clients
     */
    public function setCategorieCode($CategorieCode)
    {
      $this->CategorieCode = $CategorieCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCategorieTitle()
    {
      return $this->CategorieTitle;
    }

    /**
     * @param string $CategorieTitle
     * @return Clients
     */
    public function setCategorieTitle($CategorieTitle)
    {
      $this->CategorieTitle = $CategorieTitle;
      return $this;
    }

    /**
     * @return float
     */
    public function getEncoursCommande()
    {
      return $this->EncoursCommande;
    }

    /**
     * @param float $EncoursCommande
     * @return Clients
     */
    public function setEncoursCommande($EncoursCommande)
    {
      $this->EncoursCommande = $EncoursCommande;
      return $this;
    }

    /**
     * @return float
     */
    public function getEncoursComptable()
    {
      return $this->EncoursComptable;
    }

    /**
     * @param float $EncoursComptable
     * @return Clients
     */
    public function setEncoursComptable($EncoursComptable)
    {
      $this->EncoursComptable = $EncoursComptable;
      return $this;
    }

    /**
     * @return float
     */
    public function getEncoursTotal()
    {
      return $this->EncoursTotal;
    }

    /**
     * @param float $EncoursTotal
     * @return Clients
     */
    public function setEncoursTotal($EncoursTotal)
    {
      $this->EncoursTotal = $EncoursTotal;
      return $this;
    }

    /**
     * @return string
     */
    public function getSecteurComCode()
    {
      return $this->SecteurComCode;
    }

    /**
     * @param string $SecteurComCode
     * @return Clients
     */
    public function setSecteurComCode($SecteurComCode)
    {
      $this->SecteurComCode = $SecteurComCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getSecteurComTitle()
    {
      return $this->SecteurComTitle;
    }

    /**
     * @param string $SecteurComTitle
     * @return Clients
     */
    public function setSecteurComTitle($SecteurComTitle)
    {
      $this->SecteurComTitle = $SecteurComTitle;
      return $this;
    }

    /**
     * @return string
     */
    public function getMarcheComCode()
    {
      return $this->MarcheComCode;
    }

    /**
     * @param string $MarcheComCode
     * @return Clients
     */
    public function setMarcheComCode($MarcheComCode)
    {
      $this->MarcheComCode = $MarcheComCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getMarcheComTitle()
    {
      return $this->MarcheComTitle;
    }

    /**
     * @param string $MarcheComTitle
     * @return Clients
     */
    public function setMarcheComTitle($MarcheComTitle)
    {
      $this->MarcheComTitle = $MarcheComTitle;
      return $this;
    }

    /**
     * @return string
     */
    public function getRegionComLib()
    {
      return $this->RegionComLib;
    }

    /**
     * @param string $RegionComLib
     * @return Clients
     */
    public function setRegionComLib($RegionComLib)
    {
      $this->RegionComLib = $RegionComLib;
      return $this;
    }

    /**
     * @return string
     */
    public function getRegionComTitle()
    {
      return $this->RegionComTitle;
    }

    /**
     * @param string $RegionComTitle
     * @return Clients
     */
    public function setRegionComTitle($RegionComTitle)
    {
      $this->RegionComTitle = $RegionComTitle;
      return $this;
    }

    /**
     * @return int
     */
    public function getModeComCode()
    {
      return $this->ModeComCode;
    }

    /**
     * @param int $ModeComCode
     * @return Clients
     */
    public function setModeComCode($ModeComCode)
    {
      $this->ModeComCode = $ModeComCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getModeComTitle()
    {
      return $this->ModeComTitle;
    }

    /**
     * @param string $ModeComTitle
     * @return Clients
     */
    public function setModeComTitle($ModeComTitle)
    {
      $this->ModeComTitle = $ModeComTitle;
      return $this;
    }

    /**
     * @return string
     */
    public function getTelMobile()
    {
      return $this->TelMobile;
    }

    /**
     * @param string $TelMobile
     * @return Clients
     */
    public function setTelMobile($TelMobile)
    {
      $this->TelMobile = $TelMobile;
      return $this;
    }

    /**
     * @return string
     */
    public function getTelFixe()
    {
      return $this->TelFixe;
    }

    /**
     * @param string $TelFixe
     * @return Clients
     */
    public function setTelFixe($TelFixe)
    {
      $this->TelFixe = $TelFixe;
      return $this;
    }

    /**
     * @return string
     */
    public function getCommercialCode()
    {
      return $this->CommercialCode;
    }

    /**
     * @param string $CommercialCode
     * @return Clients
     */
    public function setCommercialCode($CommercialCode)
    {
      $this->CommercialCode = $CommercialCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getCommercialTitle()
    {
      return $this->CommercialTitle;
    }

    /**
     * @param string $CommercialTitle
     * @return Clients
     */
    public function setCommercialTitle($CommercialTitle)
    {
      $this->CommercialTitle = $CommercialTitle;
      return $this;
    }

    /**
     * @return float
     */
    public function getPerRemise()
    {
      return $this->PerRemise;
    }

    /**
     * @param float $PerRemise
     * @return Clients
     */
    public function setPerRemise($PerRemise)
    {
      $this->PerRemise = $PerRemise;
      return $this;
    }

    /**
     * @return int
     */
    public function getTarifCode()
    {
      return $this->TarifCode;
    }

    /**
     * @param int $TarifCode
     * @return Clients
     */
    public function setTarifCode($TarifCode)
    {
      $this->TarifCode = $TarifCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getTarifTitle()
    {
      return $this->TarifTitle;
    }

    /**
     * @param string $TarifTitle
     * @return Clients
     */
    public function setTarifTitle($TarifTitle)
    {
      $this->TarifTitle = $TarifTitle;
      return $this;
    }

    /**
     * @return int
     */
    public function getLangueCode()
    {
      return $this->LangueCode;
    }

    /**
     * @param int $LangueCode
     * @return Clients
     */
    public function setLangueCode($LangueCode)
    {
      $this->LangueCode = $LangueCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getLangueTitle()
    {
      return $this->LangueTitle;
    }

    /**
     * @param string $LangueTitle
     * @return Clients
     */
    public function setLangueTitle($LangueTitle)
    {
      $this->LangueTitle = $LangueTitle;
      return $this;
    }

    /**
     * @return string
     */
    public function getIsError()
    {
      return $this->IsError;
    }

    /**
     * @param string $IsError
     * @return Clients
     */
    public function setIsError($IsError)
    {
      $this->IsError = $IsError;
      return $this;
    }

    /**
     * @return int
     */
    public function getErrorCode()
    {
      return $this->ErrorCode;
    }

    /**
     * @param int $ErrorCode
     * @return Clients
     */
    public function setErrorCode($ErrorCode)
    {
      $this->ErrorCode = $ErrorCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
      return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return Clients
     */
    public function setErrorMessage($ErrorMessage)
    {
      $this->ErrorMessage = $ErrorMessage;
      return $this;
    }

}
